/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpoint.model.EndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.ListOfEndpointResponseCopier;
import software.amazon.awssdk.services.pinpoint.transform.EndpointsResponseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointsResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointsResponse> {
    private final List<EndpointResponse> item;

    private EndpointsResponse(BuilderImpl builder) {
        this.item = builder.item;
    }

    public List<EndpointResponse> item() {
        return this.item;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointsResponse)) {
            return false;
        }
        EndpointsResponse other = (EndpointsResponse)obj;
        return Objects.equals(this.item(), other.item());
    }

    public String toString() {
        return ToString.builder((String)"EndpointsResponse").add("Item", this.item()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.ofNullable(clazz.cast(this.item()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointsResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EndpointResponse> item = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointsResponse model) {
            this.item(model.item);
        }

        public final Collection<EndpointResponse.Builder> getItem() {
            return this.item != null ? (Collection)this.item.stream().map(EndpointResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<EndpointResponse> item) {
            this.item = ListOfEndpointResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(EndpointResponse ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(Consumer<EndpointResponse.Builder> ... item) {
            this.item(Stream.of(item).map(c -> (EndpointResponse)((EndpointResponse.Builder)EndpointResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItem(Collection<EndpointResponse.BuilderImpl> item) {
            this.item = ListOfEndpointResponseCopier.copyFromBuilder(item);
        }

        public EndpointsResponse build() {
            return new EndpointsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointsResponse> {
        public Builder item(Collection<EndpointResponse> var1);

        public Builder item(EndpointResponse ... var1);

        public Builder item(Consumer<EndpointResponse.Builder> ... var1);
    }
}

