/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.DeliveryStatus;
import software.amazon.awssdk.services.pinpoint.transform.EndpointMessageResultMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointMessageResult
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointMessageResult> {
    private final String address;
    private final String deliveryStatus;
    private final String messageId;
    private final Integer statusCode;
    private final String statusMessage;
    private final String updatedToken;

    private EndpointMessageResult(BuilderImpl builder) {
        this.address = builder.address;
        this.deliveryStatus = builder.deliveryStatus;
        this.messageId = builder.messageId;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.updatedToken = builder.updatedToken;
    }

    public String address() {
        return this.address;
    }

    public DeliveryStatus deliveryStatus() {
        return DeliveryStatus.fromValue(this.deliveryStatus);
    }

    public String deliveryStatusAsString() {
        return this.deliveryStatus;
    }

    public String messageId() {
        return this.messageId;
    }

    public Integer statusCode() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String updatedToken() {
        return this.updatedToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointMessageResult)) {
            return false;
        }
        EndpointMessageResult other = (EndpointMessageResult)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.deliveryStatusAsString(), other.deliveryStatusAsString()) && Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.updatedToken(), other.updatedToken());
    }

    public String toString() {
        return ToString.builder((String)"EndpointMessageResult").add("Address", (Object)this.address()).add("DeliveryStatus", (Object)this.deliveryStatusAsString()).add("MessageId", (Object)this.messageId()).add("StatusCode", (Object)this.statusCode()).add("StatusMessage", (Object)this.statusMessage()).add("UpdatedToken", (Object)this.updatedToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "DeliveryStatus": {
                return Optional.ofNullable(clazz.cast(this.deliveryStatusAsString()));
            }
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "UpdatedToken": {
                return Optional.ofNullable(clazz.cast(this.updatedToken()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointMessageResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String address;
        private String deliveryStatus;
        private String messageId;
        private Integer statusCode;
        private String statusMessage;
        private String updatedToken;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointMessageResult model) {
            this.address(model.address);
            this.deliveryStatus(model.deliveryStatus);
            this.messageId(model.messageId);
            this.statusCode(model.statusCode);
            this.statusMessage(model.statusMessage);
            this.updatedToken(model.updatedToken);
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getDeliveryStatus() {
            return this.deliveryStatus;
        }

        @Override
        public final Builder deliveryStatus(String deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
            return this;
        }

        @Override
        public final Builder deliveryStatus(DeliveryStatus deliveryStatus) {
            this.deliveryStatus(deliveryStatus.toString());
            return this;
        }

        public final void setDeliveryStatus(String deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getUpdatedToken() {
            return this.updatedToken;
        }

        @Override
        public final Builder updatedToken(String updatedToken) {
            this.updatedToken = updatedToken;
            return this;
        }

        public final void setUpdatedToken(String updatedToken) {
            this.updatedToken = updatedToken;
        }

        public EndpointMessageResult build() {
            return new EndpointMessageResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointMessageResult> {
        public Builder address(String var1);

        public Builder deliveryStatus(String var1);

        public Builder deliveryStatus(DeliveryStatus var1);

        public Builder messageId(String var1);

        public Builder statusCode(Integer var1);

        public Builder statusMessage(String var1);

        public Builder updatedToken(String var1);
    }
}

