/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.EndpointItemResponseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointItemResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointItemResponse> {
    private final String message;
    private final Integer statusCode;

    private EndpointItemResponse(BuilderImpl builder) {
        this.message = builder.message;
        this.statusCode = builder.statusCode;
    }

    public String message() {
        return this.message;
    }

    public Integer statusCode() {
        return this.statusCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointItemResponse)) {
            return false;
        }
        EndpointItemResponse other = (EndpointItemResponse)obj;
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.statusCode(), other.statusCode());
    }

    public String toString() {
        return ToString.builder((String)"EndpointItemResponse").add("Message", (Object)this.message()).add("StatusCode", (Object)this.statusCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointItemResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointItemResponse model) {
            this.message(model.message);
            this.statusCode(model.statusCode);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public EndpointItemResponse build() {
            return new EndpointItemResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointItemResponse> {
        public Builder message(String var1);

        public Builder statusCode(Integer var1);
    }
}

