/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.BaiduChannelRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BaiduChannelRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, BaiduChannelRequest> {
    private final String apiKey;
    private final Boolean enabled;
    private final String secretKey;

    private BaiduChannelRequest(BuilderImpl builder) {
        this.apiKey = builder.apiKey;
        this.enabled = builder.enabled;
        this.secretKey = builder.secretKey;
    }

    public String apiKey() {
        return this.apiKey;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String secretKey() {
        return this.secretKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaiduChannelRequest)) {
            return false;
        }
        BaiduChannelRequest other = (BaiduChannelRequest)obj;
        return Objects.equals(this.apiKey(), other.apiKey()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.secretKey(), other.secretKey());
    }

    public String toString() {
        return ToString.builder((String)"BaiduChannelRequest").add("ApiKey", (Object)this.apiKey()).add("Enabled", (Object)this.enabled()).add("SecretKey", (Object)this.secretKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiKey": {
                return Optional.ofNullable(clazz.cast(this.apiKey()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "SecretKey": {
                return Optional.ofNullable(clazz.cast(this.secretKey()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BaiduChannelRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiKey;
        private Boolean enabled;
        private String secretKey;

        private BuilderImpl() {
        }

        private BuilderImpl(BaiduChannelRequest model) {
            this.apiKey(model.apiKey);
            this.enabled(model.enabled);
            this.secretKey(model.secretKey);
        }

        public final String getApiKey() {
            return this.apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getSecretKey() {
            return this.secretKey;
        }

        @Override
        public final Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public final void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public BaiduChannelRequest build() {
            return new BaiduChannelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BaiduChannelRequest> {
        public Builder apiKey(String var1);

        public Builder enabled(Boolean var1);

        public Builder secretKey(String var1);
    }
}

