/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.WriteEventStream;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class WriteEventStreamMarshaller {
    private static final MarshallingInfo<String> DESTINATIONSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationStreamArn").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final WriteEventStreamMarshaller INSTANCE = new WriteEventStreamMarshaller();

    private WriteEventStreamMarshaller() {
    }

    public static WriteEventStreamMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WriteEventStream writeEventStream, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)writeEventStream, (String)"writeEventStream");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)writeEventStream.destinationStreamArn(), DESTINATIONSTREAMARN_BINDING);
            protocolMarshaller.marshall((Object)writeEventStream.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

