/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.ImportJobResource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImportJobResourceMarshaller {
    private static final MarshallingInfo<Boolean> DEFINESEGMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefineSegment").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalId").isBinary(false).build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REGISTERENDPOINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegisterEndpoints").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> S3URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Url").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentId").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentName").isBinary(false).build();
    private static final ImportJobResourceMarshaller INSTANCE = new ImportJobResourceMarshaller();

    private ImportJobResourceMarshaller() {
    }

    public static ImportJobResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImportJobResource importJobResource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)importJobResource, (String)"importJobResource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)importJobResource.defineSegment(), DEFINESEGMENT_BINDING);
            protocolMarshaller.marshall((Object)importJobResource.externalId(), EXTERNALID_BINDING);
            protocolMarshaller.marshall((Object)importJobResource.formatAsString(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)importJobResource.registerEndpoints(), REGISTERENDPOINTS_BINDING);
            protocolMarshaller.marshall((Object)importJobResource.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)importJobResource.s3Url(), S3URL_BINDING);
            protocolMarshaller.marshall((Object)importJobResource.segmentId(), SEGMENTID_BINDING);
            protocolMarshaller.marshall((Object)importJobResource.segmentName(), SEGMENTNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

