/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.EventStreamMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventStream
implements StructuredPojo,
ToCopyableBuilder<Builder, EventStream> {
    private final String applicationId;
    private final String destinationStreamArn;
    private final String externalId;
    private final String lastModifiedDate;
    private final String lastUpdatedBy;
    private final String roleArn;

    private EventStream(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.destinationStreamArn = builder.destinationStreamArn;
        this.externalId = builder.externalId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.roleArn = builder.roleArn;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String destinationStreamArn() {
        return this.destinationStreamArn;
    }

    public String externalId() {
        return this.externalId;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventStream)) {
            return false;
        }
        EventStream other = (EventStream)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.destinationStreamArn(), other.destinationStreamArn()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"EventStream").add("ApplicationId", (Object)this.applicationId()).add("DestinationStreamArn", (Object)this.destinationStreamArn()).add("ExternalId", (Object)this.externalId()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LastUpdatedBy", (Object)this.lastUpdatedBy()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "DestinationStreamArn": {
                return Optional.ofNullable(clazz.cast(this.destinationStreamArn()));
            }
            case "ExternalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String destinationStreamArn;
        private String externalId;
        private String lastModifiedDate;
        private String lastUpdatedBy;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EventStream model) {
            this.applicationId(model.applicationId);
            this.destinationStreamArn(model.destinationStreamArn);
            this.externalId(model.externalId);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lastUpdatedBy(model.lastUpdatedBy);
            this.roleArn(model.roleArn);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getDestinationStreamArn() {
            return this.destinationStreamArn;
        }

        @Override
        public final Builder destinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
            return this;
        }

        public final void setDestinationStreamArn(String destinationStreamArn) {
            this.destinationStreamArn = destinationStreamArn;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public EventStream build() {
            return new EventStream(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventStream> {
        public Builder applicationId(String var1);

        public Builder destinationStreamArn(String var1);

        public Builder externalId(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder lastUpdatedBy(String var1);

        public Builder roleArn(String var1);
    }
}

