/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.WriteTreatmentResource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class WriteTreatmentResourceMarshaller {
    private static final MarshallingInfo<StructuredPojo> MESSAGECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCHEDULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Schedule").isBinary(false).build();
    private static final MarshallingInfo<Integer> SIZEPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizePercent").isBinary(false).build();
    private static final MarshallingInfo<String> TREATMENTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TreatmentDescription").isBinary(false).build();
    private static final MarshallingInfo<String> TREATMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TreatmentName").isBinary(false).build();
    private static final WriteTreatmentResourceMarshaller INSTANCE = new WriteTreatmentResourceMarshaller();

    private WriteTreatmentResourceMarshaller() {
    }

    public static WriteTreatmentResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WriteTreatmentResource writeTreatmentResource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)writeTreatmentResource, (String)"writeTreatmentResource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)writeTreatmentResource.messageConfiguration(), MESSAGECONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)writeTreatmentResource.schedule(), SCHEDULE_BINDING);
            protocolMarshaller.marshall((Object)writeTreatmentResource.sizePercent(), SIZEPERCENT_BINDING);
            protocolMarshaller.marshall((Object)writeTreatmentResource.treatmentDescription(), TREATMENTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)writeTreatmentResource.treatmentName(), TREATMENTNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

