/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.TreatmentResource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TreatmentResourceMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MESSAGECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCHEDULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Schedule").isBinary(false).build();
    private static final MarshallingInfo<Integer> SIZEPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizePercent").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<String> TREATMENTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TreatmentDescription").isBinary(false).build();
    private static final MarshallingInfo<String> TREATMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TreatmentName").isBinary(false).build();
    private static final TreatmentResourceMarshaller INSTANCE = new TreatmentResourceMarshaller();

    private TreatmentResourceMarshaller() {
    }

    public static TreatmentResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TreatmentResource treatmentResource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)treatmentResource, (String)"treatmentResource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)treatmentResource.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)treatmentResource.messageConfiguration(), MESSAGECONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)treatmentResource.schedule(), SCHEDULE_BINDING);
            protocolMarshaller.marshall((Object)treatmentResource.sizePercent(), SIZEPERCENT_BINDING);
            protocolMarshaller.marshall((Object)treatmentResource.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)treatmentResource.treatmentDescription(), TREATMENTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)treatmentResource.treatmentName(), TREATMENTNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

