/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.SegmentResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SegmentResponseMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").isBinary(false).build();
    private static final MarshallingInfo<String> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DIMENSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimensions").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> IMPORTDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportDefinition").isBinary(false).build();
    private static final MarshallingInfo<String> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentType").isBinary(false).build();
    private static final MarshallingInfo<Integer> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final SegmentResponseMarshaller INSTANCE = new SegmentResponseMarshaller();

    private SegmentResponseMarshaller() {
    }

    public static SegmentResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SegmentResponse segmentResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)segmentResponse, (String)"segmentResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)segmentResponse.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)segmentResponse.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)segmentResponse.dimensions(), DIMENSIONS_BINDING);
            protocolMarshaller.marshall((Object)segmentResponse.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)segmentResponse.importDefinition(), IMPORTDEFINITION_BINDING);
            protocolMarshaller.marshall((Object)segmentResponse.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)segmentResponse.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)segmentResponse.segmentTypeAsString(), SEGMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)segmentResponse.version(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

