/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.SegmentImportResource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SegmentImportResourceMarshaller {
    private static final MarshallingInfo<Map> CHANNELCOUNTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChannelCounts").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalId").isBinary(false).build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> S3URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Url").isBinary(false).build();
    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").isBinary(false).build();
    private static final SegmentImportResourceMarshaller INSTANCE = new SegmentImportResourceMarshaller();

    private SegmentImportResourceMarshaller() {
    }

    public static SegmentImportResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SegmentImportResource segmentImportResource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)segmentImportResource, (String)"segmentImportResource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(segmentImportResource.channelCounts(), CHANNELCOUNTS_BINDING);
            protocolMarshaller.marshall((Object)segmentImportResource.externalId(), EXTERNALID_BINDING);
            protocolMarshaller.marshall((Object)segmentImportResource.formatAsString(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)segmentImportResource.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)segmentImportResource.s3Url(), S3URL_BINDING);
            protocolMarshaller.marshall((Object)segmentImportResource.size(), SIZE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

