/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.EndpointLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EndpointLocationMarshaller {
    private static final MarshallingInfo<String> CITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("City").isBinary(false).build();
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Country").isBinary(false).build();
    private static final MarshallingInfo<Double> LATITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Latitude").isBinary(false).build();
    private static final MarshallingInfo<Double> LONGITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Longitude").isBinary(false).build();
    private static final MarshallingInfo<String> POSTALCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PostalCode").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();
    private static final EndpointLocationMarshaller INSTANCE = new EndpointLocationMarshaller();

    private EndpointLocationMarshaller() {
    }

    public static EndpointLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EndpointLocation endpointLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)endpointLocation, (String)"endpointLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)endpointLocation.city(), CITY_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.country(), COUNTRY_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.latitude(), LATITUDE_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.longitude(), LONGITUDE_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.postalCode(), POSTALCODE_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.region(), REGION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

