/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.AttributeDimension;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttributeDimensionMarshaller {
    private static final MarshallingInfo<String> ATTRIBUTETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeType").isBinary(false).build();
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Values").isBinary(false).build();
    private static final AttributeDimensionMarshaller INSTANCE = new AttributeDimensionMarshaller();

    private AttributeDimensionMarshaller() {
    }

    public static AttributeDimensionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttributeDimension attributeDimension, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)attributeDimension, (String)"attributeDimension");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attributeDimension.attributeTypeAsString(), ATTRIBUTETYPE_BINDING);
            protocolMarshaller.marshall(attributeDimension.values(), VALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

