/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.pinpoint.model.EmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateEmailChannelRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateEmailChannelRequest> {
    private final String applicationId;
    private final EmailChannelRequest emailChannelRequest;

    private UpdateEmailChannelRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.emailChannelRequest = builder.emailChannelRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public EmailChannelRequest emailChannelRequest() {
        return this.emailChannelRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailChannelRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEmailChannelRequest)) {
            return false;
        }
        UpdateEmailChannelRequest other = (UpdateEmailChannelRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.emailChannelRequest(), other.emailChannelRequest());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEmailChannelRequest").add("ApplicationId", (Object)this.applicationId()).add("EmailChannelRequest", (Object)this.emailChannelRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "EmailChannelRequest": {
                return Optional.of(clazz.cast(this.emailChannelRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private EmailChannelRequest emailChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEmailChannelRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.emailChannelRequest(model.emailChannelRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final EmailChannelRequest.Builder getEmailChannelRequest() {
            return this.emailChannelRequest != null ? this.emailChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder emailChannelRequest(EmailChannelRequest emailChannelRequest) {
            this.emailChannelRequest = emailChannelRequest;
            return this;
        }

        public final void setEmailChannelRequest(EmailChannelRequest.BuilderImpl emailChannelRequest) {
            this.emailChannelRequest = emailChannelRequest != null ? emailChannelRequest.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateEmailChannelRequest build() {
            return new UpdateEmailChannelRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, UpdateEmailChannelRequest> {
        public Builder applicationId(String var1);

        public Builder emailChannelRequest(EmailChannelRequest var1);

        default public Builder emailChannelRequest(Consumer<EmailChannelRequest.Builder> emailChannelRequest) {
            return this.emailChannelRequest((EmailChannelRequest)((EmailChannelRequest.Builder)EmailChannelRequest.builder().apply(emailChannelRequest)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

