/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateApplicationSettingsRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateApplicationSettingsRequest> {
    private final String applicationId;
    private final WriteApplicationSettingsRequest writeApplicationSettingsRequest;

    private UpdateApplicationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.writeApplicationSettingsRequest = builder.writeApplicationSettingsRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public WriteApplicationSettingsRequest writeApplicationSettingsRequest() {
        return this.writeApplicationSettingsRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeApplicationSettingsRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationSettingsRequest)) {
            return false;
        }
        UpdateApplicationSettingsRequest other = (UpdateApplicationSettingsRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.writeApplicationSettingsRequest(), other.writeApplicationSettingsRequest());
    }

    public String toString() {
        return ToString.builder((String)"UpdateApplicationSettingsRequest").add("ApplicationId", (Object)this.applicationId()).add("WriteApplicationSettingsRequest", (Object)this.writeApplicationSettingsRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "WriteApplicationSettingsRequest": {
                return Optional.of(clazz.cast(this.writeApplicationSettingsRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private WriteApplicationSettingsRequest writeApplicationSettingsRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationSettingsRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.writeApplicationSettingsRequest(model.writeApplicationSettingsRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final WriteApplicationSettingsRequest.Builder getWriteApplicationSettingsRequest() {
            return this.writeApplicationSettingsRequest != null ? this.writeApplicationSettingsRequest.toBuilder() : null;
        }

        @Override
        public final Builder writeApplicationSettingsRequest(WriteApplicationSettingsRequest writeApplicationSettingsRequest) {
            this.writeApplicationSettingsRequest = writeApplicationSettingsRequest;
            return this;
        }

        public final void setWriteApplicationSettingsRequest(WriteApplicationSettingsRequest.BuilderImpl writeApplicationSettingsRequest) {
            this.writeApplicationSettingsRequest = writeApplicationSettingsRequest != null ? writeApplicationSettingsRequest.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationSettingsRequest build() {
            return new UpdateApplicationSettingsRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, UpdateApplicationSettingsRequest> {
        public Builder applicationId(String var1);

        public Builder writeApplicationSettingsRequest(WriteApplicationSettingsRequest var1);

        default public Builder writeApplicationSettingsRequest(Consumer<WriteApplicationSettingsRequest.Builder> writeApplicationSettingsRequest) {
            return this.writeApplicationSettingsRequest((WriteApplicationSettingsRequest)((WriteApplicationSettingsRequest.Builder)WriteApplicationSettingsRequest.builder().apply(writeApplicationSettingsRequest)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

