/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.EndpointDemographic;

@SdkInternalApi
public class EndpointDemographicMarshaller {
    private static final MarshallingInfo<String> APPVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppVersion").build();
    private static final MarshallingInfo<String> LOCALE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Locale").build();
    private static final MarshallingInfo<String> MAKE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Make").build();
    private static final MarshallingInfo<String> MODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Model").build();
    private static final MarshallingInfo<String> MODELVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelVersion").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Platform").build();
    private static final MarshallingInfo<String> PLATFORMVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformVersion").build();
    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timezone").build();
    private static final EndpointDemographicMarshaller instance = new EndpointDemographicMarshaller();

    public static EndpointDemographicMarshaller getInstance() {
        return instance;
    }

    public void marshall(EndpointDemographic endpointDemographic, ProtocolMarshaller protocolMarshaller) {
        if (endpointDemographic == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)endpointDemographic.appVersion(), APPVERSION_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.locale(), LOCALE_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.make(), MAKE_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.model(), MODEL_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.modelVersion(), MODELVERSION_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.platform(), PLATFORM_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.platformVersion(), PLATFORMVERSION_BINDING);
            protocolMarshaller.marshall((Object)endpointDemographic.timezone(), TIMEZONE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

