/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.MessageBodyMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MessageBody
implements StructuredPojo,
ToCopyableBuilder<Builder, MessageBody> {
    private final String message;
    private final String requestID;

    private MessageBody(BuilderImpl builder) {
        this.message = builder.message;
        this.requestID = builder.requestID;
    }

    public String message() {
        return this.message;
    }

    public String requestID() {
        return this.requestID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.requestID() == null ? 0 : this.requestID().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageBody)) {
            return false;
        }
        MessageBody other = (MessageBody)obj;
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.requestID() == null ^ this.requestID() == null) {
            return false;
        }
        return other.requestID() == null || other.requestID().equals(this.requestID());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.requestID() != null) {
            sb.append("RequestID: ").append(this.requestID()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageBodyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String message;
        private String requestID;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageBody model) {
            this.setMessage(model.message);
            this.setRequestID(model.requestID);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getRequestID() {
            return this.requestID;
        }

        @Override
        public final Builder requestID(String requestID) {
            this.requestID = requestID;
            return this;
        }

        public final void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        public MessageBody build() {
            return new MessageBody(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageBody> {
        public Builder message(String var1);

        public Builder requestID(String var1);
    }
}

