/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.AttributeType;
import software.amazon.awssdk.services.pinpoint.model.ListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.AttributeDimensionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttributeDimension
implements StructuredPojo,
ToCopyableBuilder<Builder, AttributeDimension> {
    private final String attributeType;
    private final List<String> values;

    private AttributeDimension(BuilderImpl builder) {
        this.attributeType = builder.attributeType;
        this.values = builder.values;
    }

    public String attributeType() {
        return this.attributeType;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributeType() == null ? 0 : this.attributeType().hashCode());
        hashCode = 31 * hashCode + (this.values() == null ? 0 : this.values().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeDimension)) {
            return false;
        }
        AttributeDimension other = (AttributeDimension)obj;
        if (other.attributeType() == null ^ this.attributeType() == null) {
            return false;
        }
        if (other.attributeType() != null && !other.attributeType().equals(this.attributeType())) {
            return false;
        }
        if (other.values() == null ^ this.values() == null) {
            return false;
        }
        return other.values() == null || other.values().equals(this.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributeType() != null) {
            sb.append("AttributeType: ").append(this.attributeType()).append(",");
        }
        if (this.values() != null) {
            sb.append("Values: ").append(this.values()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeDimensionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String attributeType;
        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeDimension model) {
            this.setAttributeType(model.attributeType);
            this.setValues(model.values);
        }

        public final String getAttributeType() {
            return this.attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        @Override
        public final Builder attributeType(AttributeType attributeType) {
            this.attributeType(attributeType.toString());
            return this;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        public final void setAttributeType(AttributeType attributeType) {
            this.attributeType(attributeType.toString());
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            if (this.values == null) {
                this.values = new ArrayList<String>(values.length);
            }
            for (String e : values) {
                this.values.add(e);
            }
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
        }

        @SafeVarargs
        public final void setValues(String ... values) {
            if (this.values == null) {
                this.values = new ArrayList<String>(values.length);
            }
            for (String e : values) {
                this.values.add(e);
            }
        }

        public AttributeDimension build() {
            return new AttributeDimension(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttributeDimension> {
        public Builder attributeType(String var1);

        public Builder attributeType(AttributeType var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

