/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pi.model.ContextType;
import software.amazon.awssdk.services.pi.model.Data;
import software.amazon.awssdk.services.pi.model.DataListCopier;
import software.amazon.awssdk.services.pi.model.InsightListCopier;
import software.amazon.awssdk.services.pi.model.Recommendation;
import software.amazon.awssdk.services.pi.model.RecommendationListCopier;
import software.amazon.awssdk.services.pi.model.Severity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Insight
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Insight> {
    private static final SdkField<String> INSIGHT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightId").getter(Insight.getter(Insight::insightId)).setter(Insight.setter(Builder::insightId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightId").build()}).build();
    private static final SdkField<String> INSIGHT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightType").getter(Insight.getter(Insight::insightType)).setter(Insight.setter(Builder::insightType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightType").build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Context").getter(Insight.getter(Insight::contextAsString)).setter(Insight.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(Insight.getter(Insight::startTime)).setter(Insight.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(Insight.getter(Insight::endTime)).setter(Insight.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(Insight.getter(Insight::severityAsString)).setter(Insight.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<List<Insight>> SUPPORTING_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportingInsights").getter(Insight.getter(Insight::supportingInsights)).setter(Insight.setter(Builder::supportingInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportingInsights").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Insight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Insight.getter(Insight::description)).setter(Insight.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Recommendation>> RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Recommendations").getter(Insight.getter(Insight::recommendations)).setter(Insight.setter(Builder::recommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Recommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Data>> INSIGHT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsightData").getter(Insight.getter(Insight::insightData)).setter(Insight.setter(Builder::insightData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Data::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Data>> BASELINE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BaselineData").getter(Insight.getter(Insight::baselineData)).setter(Insight.setter(Builder::baselineData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Data::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ID_FIELD, INSIGHT_TYPE_FIELD, CONTEXT_FIELD, START_TIME_FIELD, END_TIME_FIELD, SEVERITY_FIELD, SUPPORTING_INSIGHTS_FIELD, DESCRIPTION_FIELD, RECOMMENDATIONS_FIELD, INSIGHT_DATA_FIELD, BASELINE_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Insight.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String insightId;
    private final String insightType;
    private final String context;
    private final Instant startTime;
    private final Instant endTime;
    private final String severity;
    private final List<Insight> supportingInsights;
    private final String description;
    private final List<Recommendation> recommendations;
    private final List<Data> insightData;
    private final List<Data> baselineData;

    private Insight(BuilderImpl builder) {
        this.insightId = builder.insightId;
        this.insightType = builder.insightType;
        this.context = builder.context;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.severity = builder.severity;
        this.supportingInsights = builder.supportingInsights;
        this.description = builder.description;
        this.recommendations = builder.recommendations;
        this.insightData = builder.insightData;
        this.baselineData = builder.baselineData;
    }

    public final String insightId() {
        return this.insightId;
    }

    public final String insightType() {
        return this.insightType;
    }

    public final ContextType context() {
        return ContextType.fromValue(this.context);
    }

    public final String contextAsString() {
        return this.context;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Severity severity() {
        return Severity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final boolean hasSupportingInsights() {
        return this.supportingInsights != null && !(this.supportingInsights instanceof SdkAutoConstructList);
    }

    public final List<Insight> supportingInsights() {
        return this.supportingInsights;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRecommendations() {
        return this.recommendations != null && !(this.recommendations instanceof SdkAutoConstructList);
    }

    public final List<Recommendation> recommendations() {
        return this.recommendations;
    }

    public final boolean hasInsightData() {
        return this.insightData != null && !(this.insightData instanceof SdkAutoConstructList);
    }

    public final List<Data> insightData() {
        return this.insightData;
    }

    public final boolean hasBaselineData() {
        return this.baselineData != null && !(this.baselineData instanceof SdkAutoConstructList);
    }

    public final List<Data> baselineData() {
        return this.baselineData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.insightId());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightType());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportingInsights() ? this.supportingInsights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendations() ? this.recommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsightData() ? this.insightData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBaselineData() ? this.baselineData() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Insight)) {
            return false;
        }
        Insight other = (Insight)obj;
        return Objects.equals(this.insightId(), other.insightId()) && Objects.equals(this.insightType(), other.insightType()) && Objects.equals(this.contextAsString(), other.contextAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.severityAsString(), other.severityAsString()) && this.hasSupportingInsights() == other.hasSupportingInsights() && Objects.equals(this.supportingInsights(), other.supportingInsights()) && Objects.equals(this.description(), other.description()) && this.hasRecommendations() == other.hasRecommendations() && Objects.equals(this.recommendations(), other.recommendations()) && this.hasInsightData() == other.hasInsightData() && Objects.equals(this.insightData(), other.insightData()) && this.hasBaselineData() == other.hasBaselineData() && Objects.equals(this.baselineData(), other.baselineData());
    }

    public final String toString() {
        return ToString.builder((String)"Insight").add("InsightId", (Object)this.insightId()).add("InsightType", (Object)this.insightType()).add("Context", (Object)this.contextAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Severity", (Object)this.severityAsString()).add("SupportingInsights", this.hasSupportingInsights() ? this.supportingInsights() : null).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Recommendations", this.hasRecommendations() ? this.recommendations() : null).add("InsightData", this.hasInsightData() ? this.insightData() : null).add("BaselineData", this.hasBaselineData() ? this.baselineData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsightId": {
                return Optional.ofNullable(clazz.cast(this.insightId()));
            }
            case "InsightType": {
                return Optional.ofNullable(clazz.cast(this.insightType()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.contextAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "SupportingInsights": {
                return Optional.ofNullable(clazz.cast(this.supportingInsights()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Recommendations": {
                return Optional.ofNullable(clazz.cast(this.recommendations()));
            }
            case "InsightData": {
                return Optional.ofNullable(clazz.cast(this.insightData()));
            }
            case "BaselineData": {
                return Optional.ofNullable(clazz.cast(this.baselineData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InsightId", INSIGHT_ID_FIELD);
        map.put("InsightType", INSIGHT_TYPE_FIELD);
        map.put("Context", CONTEXT_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("SupportingInsights", SUPPORTING_INSIGHTS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Recommendations", RECOMMENDATIONS_FIELD);
        map.put("InsightData", INSIGHT_DATA_FIELD);
        map.put("BaselineData", BASELINE_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Insight, T> g) {
        return obj -> g.apply((Insight)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String insightId;
        private String insightType;
        private String context;
        private Instant startTime;
        private Instant endTime;
        private String severity;
        private List<Insight> supportingInsights = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private List<Recommendation> recommendations = DefaultSdkAutoConstructList.getInstance();
        private List<Data> insightData = DefaultSdkAutoConstructList.getInstance();
        private List<Data> baselineData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Insight model) {
            this.insightId(model.insightId);
            this.insightType(model.insightType);
            this.context(model.context);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.severity(model.severity);
            this.supportingInsights(model.supportingInsights);
            this.description(model.description);
            this.recommendations(model.recommendations);
            this.insightData(model.insightData);
            this.baselineData(model.baselineData);
        }

        public final String getInsightId() {
            return this.insightId;
        }

        public final void setInsightId(String insightId) {
            this.insightId = insightId;
        }

        @Override
        public final Builder insightId(String insightId) {
            this.insightId = insightId;
            return this;
        }

        public final String getInsightType() {
            return this.insightType;
        }

        public final void setInsightType(String insightType) {
            this.insightType = insightType;
        }

        @Override
        public final Builder insightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        public final String getContext() {
            return this.context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        @Override
        public final Builder context(ContextType context) {
            this.context(context == null ? null : context.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final List<Builder> getSupportingInsights() {
            List<Builder> result = InsightListCopier.copyToBuilder(this.supportingInsights);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportingInsights(Collection<BuilderImpl> supportingInsights) {
            this.supportingInsights = InsightListCopier.copyFromBuilder(supportingInsights);
        }

        @Override
        public final Builder supportingInsights(Collection<Insight> supportingInsights) {
            this.supportingInsights = InsightListCopier.copy(supportingInsights);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingInsights(Insight ... supportingInsights) {
            this.supportingInsights(Arrays.asList(supportingInsights));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingInsights(Consumer<Builder> ... supportingInsights) {
            this.supportingInsights(Stream.of(supportingInsights).map(c -> (Insight)((Builder)Insight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Recommendation.Builder> getRecommendations() {
            List<Recommendation.Builder> result = RecommendationListCopier.copyToBuilder(this.recommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendations(Collection<Recommendation.BuilderImpl> recommendations) {
            this.recommendations = RecommendationListCopier.copyFromBuilder(recommendations);
        }

        @Override
        public final Builder recommendations(Collection<Recommendation> recommendations) {
            this.recommendations = RecommendationListCopier.copy(recommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Recommendation ... recommendations) {
            this.recommendations(Arrays.asList(recommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Consumer<Recommendation.Builder> ... recommendations) {
            this.recommendations(Stream.of(recommendations).map(c -> (Recommendation)((Recommendation.Builder)Recommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Data.Builder> getInsightData() {
            List<Data.Builder> result = DataListCopier.copyToBuilder(this.insightData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsightData(Collection<Data.BuilderImpl> insightData) {
            this.insightData = DataListCopier.copyFromBuilder(insightData);
        }

        @Override
        public final Builder insightData(Collection<Data> insightData) {
            this.insightData = DataListCopier.copy(insightData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightData(Data ... insightData) {
            this.insightData(Arrays.asList(insightData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightData(Consumer<Data.Builder> ... insightData) {
            this.insightData(Stream.of(insightData).map(c -> (Data)((Data.Builder)Data.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Data.Builder> getBaselineData() {
            List<Data.Builder> result = DataListCopier.copyToBuilder(this.baselineData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBaselineData(Collection<Data.BuilderImpl> baselineData) {
            this.baselineData = DataListCopier.copyFromBuilder(baselineData);
        }

        @Override
        public final Builder baselineData(Collection<Data> baselineData) {
            this.baselineData = DataListCopier.copy(baselineData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineData(Data ... baselineData) {
            this.baselineData(Arrays.asList(baselineData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineData(Consumer<Data.Builder> ... baselineData) {
            this.baselineData(Stream.of(baselineData).map(c -> (Data)((Data.Builder)Data.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Insight build() {
            return new Insight(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Insight> {
        public Builder insightId(String var1);

        public Builder insightType(String var1);

        public Builder context(String var1);

        public Builder context(ContextType var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder severity(String var1);

        public Builder severity(Severity var1);

        public Builder supportingInsights(Collection<Insight> var1);

        public Builder supportingInsights(Insight ... var1);

        public Builder supportingInsights(Consumer<Builder> ... var1);

        public Builder description(String var1);

        public Builder recommendations(Collection<Recommendation> var1);

        public Builder recommendations(Recommendation ... var1);

        public Builder recommendations(Consumer<Recommendation.Builder> ... var1);

        public Builder insightData(Collection<Data> var1);

        public Builder insightData(Data ... var1);

        public Builder insightData(Consumer<Data.Builder> ... var1);

        public Builder baselineData(Collection<Data> var1);

        public Builder baselineData(Data ... var1);

        public Builder baselineData(Consumer<Data.Builder> ... var1);
    }
}

