/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AcceptLanguage {
    EN_US("EN_US"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AcceptLanguage> VALUE_MAP;
    private final String value;

    private AcceptLanguage(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AcceptLanguage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AcceptLanguage> knownValues() {
        EnumSet<AcceptLanguage> knownValues = EnumSet.allOf(AcceptLanguage.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AcceptLanguage.class, AcceptLanguage::toString);
    }
}

