/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pi.model.DataPoint;
import software.amazon.awssdk.services.pi.model.DataPointsListCopier;
import software.amazon.awssdk.services.pi.model.ResponseResourceMetricKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricKeyDataPoints
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricKeyDataPoints> {
    private static final SdkField<ResponseResourceMetricKey> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Key").getter(MetricKeyDataPoints.getter(MetricKeyDataPoints::key)).setter(MetricKeyDataPoints.setter(Builder::key)).constructor(ResponseResourceMetricKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<List<DataPoint>> DATA_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataPoints").getter(MetricKeyDataPoints.getter(MetricKeyDataPoints::dataPoints)).setter(MetricKeyDataPoints.setter(Builder::dataPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, DATA_POINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Key", KEY_FIELD);
            this.put("DataPoints", DATA_POINTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ResponseResourceMetricKey key;
    private final List<DataPoint> dataPoints;

    private MetricKeyDataPoints(BuilderImpl builder) {
        this.key = builder.key;
        this.dataPoints = builder.dataPoints;
    }

    public final ResponseResourceMetricKey key() {
        return this.key;
    }

    public final boolean hasDataPoints() {
        return this.dataPoints != null && !(this.dataPoints instanceof SdkAutoConstructList);
    }

    public final List<DataPoint> dataPoints() {
        return this.dataPoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataPoints() ? this.dataPoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricKeyDataPoints)) {
            return false;
        }
        MetricKeyDataPoints other = (MetricKeyDataPoints)obj;
        return Objects.equals(this.key(), other.key()) && this.hasDataPoints() == other.hasDataPoints() && Objects.equals(this.dataPoints(), other.dataPoints());
    }

    public final String toString() {
        return ToString.builder((String)"MetricKeyDataPoints").add("Key", (Object)this.key()).add("DataPoints", this.hasDataPoints() ? this.dataPoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "DataPoints": {
                return Optional.ofNullable(clazz.cast(this.dataPoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetricKeyDataPoints, T> g) {
        return obj -> g.apply((MetricKeyDataPoints)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResponseResourceMetricKey key;
        private List<DataPoint> dataPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricKeyDataPoints model) {
            this.key(model.key);
            this.dataPoints(model.dataPoints);
        }

        public final ResponseResourceMetricKey.Builder getKey() {
            return this.key != null ? this.key.toBuilder() : null;
        }

        public final void setKey(ResponseResourceMetricKey.BuilderImpl key) {
            this.key = key != null ? key.build() : null;
        }

        @Override
        public final Builder key(ResponseResourceMetricKey key) {
            this.key = key;
            return this;
        }

        public final List<DataPoint.Builder> getDataPoints() {
            List<DataPoint.Builder> result = DataPointsListCopier.copyToBuilder(this.dataPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataPoints(Collection<DataPoint.BuilderImpl> dataPoints) {
            this.dataPoints = DataPointsListCopier.copyFromBuilder(dataPoints);
        }

        @Override
        public final Builder dataPoints(Collection<DataPoint> dataPoints) {
            this.dataPoints = DataPointsListCopier.copy(dataPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPoints(DataPoint ... dataPoints) {
            this.dataPoints(Arrays.asList(dataPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPoints(Consumer<DataPoint.Builder> ... dataPoints) {
            this.dataPoints(Stream.of(dataPoints).map(c -> (DataPoint)((DataPoint.Builder)DataPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MetricKeyDataPoints build() {
            return new MetricKeyDataPoints(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricKeyDataPoints> {
        public Builder key(ResponseResourceMetricKey var1);

        default public Builder key(Consumer<ResponseResourceMetricKey.Builder> key) {
            return this.key((ResponseResourceMetricKey)((ResponseResourceMetricKey.Builder)ResponseResourceMetricKey.builder().applyMutation(key)).build());
        }

        public Builder dataPoints(Collection<DataPoint> var1);

        public Builder dataPoints(DataPoint ... var1);

        public Builder dataPoints(Consumer<DataPoint.Builder> ... var1);
    }
}

