/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pi.model.AdditionalMetricsListCopier;
import software.amazon.awssdk.services.pi.model.DimensionGroup;
import software.amazon.awssdk.services.pi.model.MetricQueryFilterMapCopier;
import software.amazon.awssdk.services.pi.model.PiRequest;
import software.amazon.awssdk.services.pi.model.ServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDimensionKeysRequest
extends PiRequest
implements ToCopyableBuilder<Builder, DescribeDimensionKeysRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceType").getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::serviceTypeAsString)).setter(DescribeDimensionKeysRequest.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::identifier)).setter(DescribeDimensionKeysRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::startTime)).setter(DescribeDimensionKeysRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::endTime)).setter(DescribeDimensionKeysRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metric").getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::metric)).setter(DescribeDimensionKeysRequest.setter(Builder::metric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()}).build();
    private static final SdkField<Integer> PERIOD_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeriodInSeconds").getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::periodInSeconds)).setter(DescribeDimensionKeysRequest.setter(Builder::periodInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodInSeconds").build()}).build();
    private static final SdkField<DimensionGroup> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GroupBy").getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::groupBy)).setter(DescribeDimensionKeysRequest.setter(Builder::groupBy)).constructor(DimensionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalMetrics").getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::additionalMetrics)).setter(DescribeDimensionKeysRequest.setter(Builder::additionalMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DimensionGroup> PARTITION_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PartitionBy").getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::partitionBy)).setter(DescribeDimensionKeysRequest.setter(Builder::partitionBy)).constructor(DimensionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionBy").build()}).build();
    private static final SdkField<Map<String, String>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Filter").getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::filter)).setter(DescribeDimensionKeysRequest.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::maxResults)).setter(DescribeDimensionKeysRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::nextToken)).setter(DescribeDimensionKeysRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD, IDENTIFIER_FIELD, START_TIME_FIELD, END_TIME_FIELD, METRIC_FIELD, PERIOD_IN_SECONDS_FIELD, GROUP_BY_FIELD, ADDITIONAL_METRICS_FIELD, PARTITION_BY_FIELD, FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ServiceType", SERVICE_TYPE_FIELD);
            this.put("Identifier", IDENTIFIER_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("Metric", METRIC_FIELD);
            this.put("PeriodInSeconds", PERIOD_IN_SECONDS_FIELD);
            this.put("GroupBy", GROUP_BY_FIELD);
            this.put("AdditionalMetrics", ADDITIONAL_METRICS_FIELD);
            this.put("PartitionBy", PARTITION_BY_FIELD);
            this.put("Filter", FILTER_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String serviceType;
    private final String identifier;
    private final Instant startTime;
    private final Instant endTime;
    private final String metric;
    private final Integer periodInSeconds;
    private final DimensionGroup groupBy;
    private final List<String> additionalMetrics;
    private final DimensionGroup partitionBy;
    private final Map<String, String> filter;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeDimensionKeysRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.metric = builder.metric;
        this.periodInSeconds = builder.periodInSeconds;
        this.groupBy = builder.groupBy;
        this.additionalMetrics = builder.additionalMetrics;
        this.partitionBy = builder.partitionBy;
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final ServiceType serviceType() {
        return ServiceType.fromValue(this.serviceType);
    }

    public final String serviceTypeAsString() {
        return this.serviceType;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String metric() {
        return this.metric;
    }

    public final Integer periodInSeconds() {
        return this.periodInSeconds;
    }

    public final DimensionGroup groupBy() {
        return this.groupBy;
    }

    public final boolean hasAdditionalMetrics() {
        return this.additionalMetrics != null && !(this.additionalMetrics instanceof SdkAutoConstructList);
    }

    public final List<String> additionalMetrics() {
        return this.additionalMetrics;
    }

    public final DimensionGroup partitionBy() {
        return this.partitionBy;
    }

    public final boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> filter() {
        return this.filter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalMetrics() ? this.additionalMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilter() ? this.filter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDimensionKeysRequest)) {
            return false;
        }
        DescribeDimensionKeysRequest other = (DescribeDimensionKeysRequest)((Object)obj);
        return Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.metric(), other.metric()) && Objects.equals(this.periodInSeconds(), other.periodInSeconds()) && Objects.equals(this.groupBy(), other.groupBy()) && this.hasAdditionalMetrics() == other.hasAdditionalMetrics() && Objects.equals(this.additionalMetrics(), other.additionalMetrics()) && Objects.equals(this.partitionBy(), other.partitionBy()) && this.hasFilter() == other.hasFilter() && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDimensionKeysRequest").add("ServiceType", (Object)this.serviceTypeAsString()).add("Identifier", (Object)this.identifier()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Metric", (Object)this.metric()).add("PeriodInSeconds", (Object)this.periodInSeconds()).add("GroupBy", (Object)this.groupBy()).add("AdditionalMetrics", this.hasAdditionalMetrics() ? this.additionalMetrics() : null).add("PartitionBy", (Object)this.partitionBy()).add("Filter", this.hasFilter() ? this.filter() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
            case "PeriodInSeconds": {
                return Optional.ofNullable(clazz.cast(this.periodInSeconds()));
            }
            case "GroupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "AdditionalMetrics": {
                return Optional.ofNullable(clazz.cast(this.additionalMetrics()));
            }
            case "PartitionBy": {
                return Optional.ofNullable(clazz.cast(this.partitionBy()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDimensionKeysRequest, T> g) {
        return obj -> g.apply((DescribeDimensionKeysRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PiRequest.BuilderImpl
    implements Builder {
        private String serviceType;
        private String identifier;
        private Instant startTime;
        private Instant endTime;
        private String metric;
        private Integer periodInSeconds;
        private DimensionGroup groupBy;
        private List<String> additionalMetrics = DefaultSdkAutoConstructList.getInstance();
        private DimensionGroup partitionBy;
        private Map<String, String> filter = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDimensionKeysRequest model) {
            super(model);
            this.serviceType(model.serviceType);
            this.identifier(model.identifier);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.metric(model.metric);
            this.periodInSeconds(model.periodInSeconds);
            this.groupBy(model.groupBy);
            this.additionalMetrics(model.additionalMetrics);
            this.partitionBy(model.partitionBy);
            this.filter(model.filter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getMetric() {
            return this.metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final Integer getPeriodInSeconds() {
            return this.periodInSeconds;
        }

        public final void setPeriodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
        }

        @Override
        public final Builder periodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
            return this;
        }

        public final DimensionGroup.Builder getGroupBy() {
            return this.groupBy != null ? this.groupBy.toBuilder() : null;
        }

        public final void setGroupBy(DimensionGroup.BuilderImpl groupBy) {
            this.groupBy = groupBy != null ? groupBy.build() : null;
        }

        @Override
        public final Builder groupBy(DimensionGroup groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public final Collection<String> getAdditionalMetrics() {
            if (this.additionalMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalMetrics;
        }

        public final void setAdditionalMetrics(Collection<String> additionalMetrics) {
            this.additionalMetrics = AdditionalMetricsListCopier.copy(additionalMetrics);
        }

        @Override
        public final Builder additionalMetrics(Collection<String> additionalMetrics) {
            this.additionalMetrics = AdditionalMetricsListCopier.copy(additionalMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetrics(String ... additionalMetrics) {
            this.additionalMetrics(Arrays.asList(additionalMetrics));
            return this;
        }

        public final DimensionGroup.Builder getPartitionBy() {
            return this.partitionBy != null ? this.partitionBy.toBuilder() : null;
        }

        public final void setPartitionBy(DimensionGroup.BuilderImpl partitionBy) {
            this.partitionBy = partitionBy != null ? partitionBy.build() : null;
        }

        @Override
        public final Builder partitionBy(DimensionGroup partitionBy) {
            this.partitionBy = partitionBy;
            return this;
        }

        public final Map<String, String> getFilter() {
            if (this.filter instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filter;
        }

        public final void setFilter(Map<String, String> filter) {
            this.filter = MetricQueryFilterMapCopier.copy(filter);
        }

        @Override
        public final Builder filter(Map<String, String> filter) {
            this.filter = MetricQueryFilterMapCopier.copy(filter);
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDimensionKeysRequest build() {
            return new DescribeDimensionKeysRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDimensionKeysRequest> {
        public Builder serviceType(String var1);

        public Builder serviceType(ServiceType var1);

        public Builder identifier(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder metric(String var1);

        public Builder periodInSeconds(Integer var1);

        public Builder groupBy(DimensionGroup var1);

        default public Builder groupBy(Consumer<DimensionGroup.Builder> groupBy) {
            return this.groupBy((DimensionGroup)((DimensionGroup.Builder)DimensionGroup.builder().applyMutation(groupBy)).build());
        }

        public Builder additionalMetrics(Collection<String> var1);

        public Builder additionalMetrics(String ... var1);

        public Builder partitionBy(DimensionGroup var1);

        default public Builder partitionBy(Consumer<DimensionGroup.Builder> partitionBy) {
            return this.partitionBy((DimensionGroup)((DimensionGroup.Builder)DimensionGroup.builder().applyMutation(partitionBy)).build());
        }

        public Builder filter(Map<String, String> var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

