/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pi.PiAsyncClient;
import software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest;
import software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse;

public class GetResourceMetricsPublisher
implements SdkPublisher<GetResourceMetricsResponse> {
    private final PiAsyncClient client;
    private final GetResourceMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourceMetricsPublisher(PiAsyncClient client, GetResourceMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourceMetricsPublisher(PiAsyncClient client, GetResourceMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourceMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourceMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetResourceMetricsResponseFetcher
    implements AsyncPageFetcher<GetResourceMetricsResponse> {
        private GetResourceMetricsResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetResourceMetricsResponse> nextPage(GetResourceMetricsResponse previousPage) {
            if (previousPage == null) {
                return GetResourceMetricsPublisher.this.client.getResourceMetrics(GetResourceMetricsPublisher.this.firstRequest);
            }
            return GetResourceMetricsPublisher.this.client.getResourceMetrics((GetResourceMetricsRequest)((Object)GetResourceMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

