/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pi.model.DimensionMapCopier;
import software.amazon.awssdk.services.pi.model.MetricValuesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DimensionKeyDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DimensionKeyDescription> {
    private static final SdkField<Map<String, String>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DimensionKeyDescription.getter(DimensionKeyDescription::dimensions)).setter(DimensionKeyDescription.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Double> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(DimensionKeyDescription.getter(DimensionKeyDescription::total)).setter(DimensionKeyDescription.setter(Builder::total)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()}).build();
    private static final SdkField<List<Double>> PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DimensionKeyDescription.getter(DimensionKeyDescription::partitions)).setter(DimensionKeyDescription.setter(Builder::partitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, TOTAL_FIELD, PARTITIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> dimensions;
    private final Double total;
    private final List<Double> partitions;

    private DimensionKeyDescription(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.total = builder.total;
        this.partitions = builder.partitions;
    }

    public boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructMap);
    }

    public Map<String, String> dimensions() {
        return this.dimensions;
    }

    public Double total() {
        return this.total;
    }

    public boolean hasPartitions() {
        return this.partitions != null && !(this.partitions instanceof SdkAutoConstructList);
    }

    public List<Double> partitions() {
        return this.partitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionKeyDescription)) {
            return false;
        }
        DimensionKeyDescription other = (DimensionKeyDescription)obj;
        return Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.total(), other.total()) && Objects.equals(this.partitions(), other.partitions());
    }

    public String toString() {
        return ToString.builder((String)"DimensionKeyDescription").add("Dimensions", this.dimensions()).add("Total", (Object)this.total()).add("Partitions", this.partitions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
            case "Partitions": {
                return Optional.ofNullable(clazz.cast(this.partitions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionKeyDescription, T> g) {
        return obj -> g.apply((DimensionKeyDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> dimensions = DefaultSdkAutoConstructMap.getInstance();
        private Double total;
        private List<Double> partitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionKeyDescription model) {
            this.dimensions(model.dimensions);
            this.total(model.total);
            this.partitions(model.partitions);
        }

        public final Map<String, String> getDimensions() {
            return this.dimensions;
        }

        @Override
        public final Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionMapCopier.copy(dimensions);
            return this;
        }

        public final void setDimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionMapCopier.copy(dimensions);
        }

        public final Double getTotal() {
            return this.total;
        }

        @Override
        public final Builder total(Double total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Double total) {
            this.total = total;
        }

        public final Collection<Double> getPartitions() {
            return this.partitions;
        }

        @Override
        public final Builder partitions(Collection<Double> partitions) {
            this.partitions = MetricValuesListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Double ... partitions) {
            this.partitions(Arrays.asList(partitions));
            return this;
        }

        public final void setPartitions(Collection<Double> partitions) {
            this.partitions = MetricValuesListCopier.copy(partitions);
        }

        public DimensionKeyDescription build() {
            return new DimensionKeyDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DimensionKeyDescription> {
        public Builder dimensions(Map<String, String> var1);

        public Builder total(Double var1);

        public Builder partitions(Collection<Double> var1);

        public Builder partitions(Double ... var1);
    }
}

