/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pi.model.DimensionKeyDescription;
import software.amazon.awssdk.services.pi.model.DimensionKeyDescriptionListCopier;
import software.amazon.awssdk.services.pi.model.PiResponse;
import software.amazon.awssdk.services.pi.model.ResponsePartitionKey;
import software.amazon.awssdk.services.pi.model.ResponsePartitionKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDimensionKeysResponse
extends PiResponse
implements ToCopyableBuilder<Builder, DescribeDimensionKeysResponse> {
    private static final SdkField<Instant> ALIGNED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeDimensionKeysResponse.getter(DescribeDimensionKeysResponse::alignedStartTime)).setter(DescribeDimensionKeysResponse.setter(Builder::alignedStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlignedStartTime").build()}).build();
    private static final SdkField<Instant> ALIGNED_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeDimensionKeysResponse.getter(DescribeDimensionKeysResponse::alignedEndTime)).setter(DescribeDimensionKeysResponse.setter(Builder::alignedEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlignedEndTime").build()}).build();
    private static final SdkField<List<ResponsePartitionKey>> PARTITION_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDimensionKeysResponse.getter(DescribeDimensionKeysResponse::partitionKeys)).setter(DescribeDimensionKeysResponse.setter(Builder::partitionKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResponsePartitionKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DimensionKeyDescription>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDimensionKeysResponse.getter(DescribeDimensionKeysResponse::keys)).setter(DescribeDimensionKeysResponse.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionKeyDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDimensionKeysResponse.getter(DescribeDimensionKeysResponse::nextToken)).setter(DescribeDimensionKeysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIGNED_START_TIME_FIELD, ALIGNED_END_TIME_FIELD, PARTITION_KEYS_FIELD, KEYS_FIELD, NEXT_TOKEN_FIELD));
    private final Instant alignedStartTime;
    private final Instant alignedEndTime;
    private final List<ResponsePartitionKey> partitionKeys;
    private final List<DimensionKeyDescription> keys;
    private final String nextToken;

    private DescribeDimensionKeysResponse(BuilderImpl builder) {
        super(builder);
        this.alignedStartTime = builder.alignedStartTime;
        this.alignedEndTime = builder.alignedEndTime;
        this.partitionKeys = builder.partitionKeys;
        this.keys = builder.keys;
        this.nextToken = builder.nextToken;
    }

    public Instant alignedStartTime() {
        return this.alignedStartTime;
    }

    public Instant alignedEndTime() {
        return this.alignedEndTime;
    }

    public boolean hasPartitionKeys() {
        return this.partitionKeys != null && !(this.partitionKeys instanceof SdkAutoConstructList);
    }

    public List<ResponsePartitionKey> partitionKeys() {
        return this.partitionKeys;
    }

    public boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructList);
    }

    public List<DimensionKeyDescription> keys() {
        return this.keys;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alignedStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.alignedEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.keys());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDimensionKeysResponse)) {
            return false;
        }
        DescribeDimensionKeysResponse other = (DescribeDimensionKeysResponse)((Object)obj);
        return Objects.equals(this.alignedStartTime(), other.alignedStartTime()) && Objects.equals(this.alignedEndTime(), other.alignedEndTime()) && Objects.equals(this.partitionKeys(), other.partitionKeys()) && Objects.equals(this.keys(), other.keys()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDimensionKeysResponse").add("AlignedStartTime", (Object)this.alignedStartTime()).add("AlignedEndTime", (Object)this.alignedEndTime()).add("PartitionKeys", this.partitionKeys()).add("Keys", this.keys()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlignedStartTime": {
                return Optional.ofNullable(clazz.cast(this.alignedStartTime()));
            }
            case "AlignedEndTime": {
                return Optional.ofNullable(clazz.cast(this.alignedEndTime()));
            }
            case "PartitionKeys": {
                return Optional.ofNullable(clazz.cast(this.partitionKeys()));
            }
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDimensionKeysResponse, T> g) {
        return obj -> g.apply((DescribeDimensionKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PiResponse.BuilderImpl
    implements Builder {
        private Instant alignedStartTime;
        private Instant alignedEndTime;
        private List<ResponsePartitionKey> partitionKeys = DefaultSdkAutoConstructList.getInstance();
        private List<DimensionKeyDescription> keys = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDimensionKeysResponse model) {
            super(model);
            this.alignedStartTime(model.alignedStartTime);
            this.alignedEndTime(model.alignedEndTime);
            this.partitionKeys(model.partitionKeys);
            this.keys(model.keys);
            this.nextToken(model.nextToken);
        }

        public final Instant getAlignedStartTime() {
            return this.alignedStartTime;
        }

        @Override
        public final Builder alignedStartTime(Instant alignedStartTime) {
            this.alignedStartTime = alignedStartTime;
            return this;
        }

        public final void setAlignedStartTime(Instant alignedStartTime) {
            this.alignedStartTime = alignedStartTime;
        }

        public final Instant getAlignedEndTime() {
            return this.alignedEndTime;
        }

        @Override
        public final Builder alignedEndTime(Instant alignedEndTime) {
            this.alignedEndTime = alignedEndTime;
            return this;
        }

        public final void setAlignedEndTime(Instant alignedEndTime) {
            this.alignedEndTime = alignedEndTime;
        }

        public final Collection<ResponsePartitionKey.Builder> getPartitionKeys() {
            return this.partitionKeys != null ? (Collection)this.partitionKeys.stream().map(ResponsePartitionKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partitionKeys(Collection<ResponsePartitionKey> partitionKeys) {
            this.partitionKeys = ResponsePartitionKeyListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(ResponsePartitionKey ... partitionKeys) {
            this.partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Consumer<ResponsePartitionKey.Builder> ... partitionKeys) {
            this.partitionKeys(Stream.of(partitionKeys).map(c -> (ResponsePartitionKey)((ResponsePartitionKey.Builder)ResponsePartitionKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPartitionKeys(Collection<ResponsePartitionKey.BuilderImpl> partitionKeys) {
            this.partitionKeys = ResponsePartitionKeyListCopier.copyFromBuilder(partitionKeys);
        }

        public final Collection<DimensionKeyDescription.Builder> getKeys() {
            return this.keys != null ? (Collection)this.keys.stream().map(DimensionKeyDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keys(Collection<DimensionKeyDescription> keys) {
            this.keys = DimensionKeyDescriptionListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(DimensionKeyDescription ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(Consumer<DimensionKeyDescription.Builder> ... keys) {
            this.keys(Stream.of(keys).map(c -> (DimensionKeyDescription)((DimensionKeyDescription.Builder)DimensionKeyDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeys(Collection<DimensionKeyDescription.BuilderImpl> keys) {
            this.keys = DimensionKeyDescriptionListCopier.copyFromBuilder(keys);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDimensionKeysResponse build() {
            return new DescribeDimensionKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDimensionKeysResponse> {
        public Builder alignedStartTime(Instant var1);

        public Builder alignedEndTime(Instant var1);

        public Builder partitionKeys(Collection<ResponsePartitionKey> var1);

        public Builder partitionKeys(ResponsePartitionKey ... var1);

        public Builder partitionKeys(Consumer<ResponsePartitionKey.Builder> ... var1);

        public Builder keys(Collection<DimensionKeyDescription> var1);

        public Builder keys(DimensionKeyDescription ... var1);

        public Builder keys(Consumer<DimensionKeyDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

