/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeAsyncClient;
import software.amazon.awssdk.services.personalize.model.DatasetSchemaSummary;
import software.amazon.awssdk.services.personalize.model.ListSchemasRequest;
import software.amazon.awssdk.services.personalize.model.ListSchemasResponse;

public class ListSchemasPublisher
implements SdkPublisher<ListSchemasResponse> {
    private final PersonalizeAsyncClient client;
    private final ListSchemasRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSchemasPublisher(PersonalizeAsyncClient client, ListSchemasRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSchemasPublisher(PersonalizeAsyncClient client, ListSchemasRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSchemasResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSchemasResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DatasetSchemaSummary> schemas() {
        Function<ListSchemasResponse, Iterator> getIterator = response -> {
            if (response != null && response.schemas() != null) {
                return response.schemas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSchemasResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSchemasResponseFetcher
    implements AsyncPageFetcher<ListSchemasResponse> {
        private ListSchemasResponseFetcher() {
        }

        public boolean hasNextPage(ListSchemasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSchemasResponse> nextPage(ListSchemasResponse previousPage) {
            if (previousPage == null) {
                return ListSchemasPublisher.this.client.listSchemas(ListSchemasPublisher.this.firstRequest);
            }
            return ListSchemasPublisher.this.client.listSchemas((ListSchemasRequest)((Object)ListSchemasPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

