/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a recipe. Each recipe provides an algorithm that Amazon Personalize uses in model training
 * when you use the <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Recipe implements SdkPojo, Serializable, ToCopyableBuilder<Recipe.Builder, Recipe> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Recipe::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recipeArn").getter(getter(Recipe::recipeArn)).setter(setter(Builder::recipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeArn").build()).build();

    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("algorithmArn").getter(getter(Recipe::algorithmArn)).setter(setter(Builder::algorithmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmArn").build()).build();

    private static final SdkField<String> FEATURE_TRANSFORMATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("featureTransformationArn").getter(getter(Recipe::featureTransformationArn))
            .setter(setter(Builder::featureTransformationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureTransformationArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Recipe::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Recipe::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(Recipe::creationDateTime)).setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> RECIPE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recipeType").getter(getter(Recipe::recipeType)).setter(setter(Builder::recipeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeType").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(Recipe::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RECIPE_ARN_FIELD,
            ALGORITHM_ARN_FIELD, FEATURE_TRANSFORMATION_ARN_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATION_DATE_TIME_FIELD,
            RECIPE_TYPE_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String recipeArn;

    private final String algorithmArn;

    private final String featureTransformationArn;

    private final String status;

    private final String description;

    private final Instant creationDateTime;

    private final String recipeType;

    private final Instant lastUpdatedDateTime;

    private Recipe(BuilderImpl builder) {
        this.name = builder.name;
        this.recipeArn = builder.recipeArn;
        this.algorithmArn = builder.algorithmArn;
        this.featureTransformationArn = builder.featureTransformationArn;
        this.status = builder.status;
        this.description = builder.description;
        this.creationDateTime = builder.creationDateTime;
        this.recipeType = builder.recipeType;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The name of the recipe.
     * </p>
     * 
     * @return The name of the recipe.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recipe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recipe.
     */
    public final String recipeArn() {
        return recipeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses to train the model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses to train the model.
     */
    public final String algorithmArn() {
        return algorithmArn;
    }

    /**
     * <p>
     * The ARN of the FeatureTransformation object.
     * </p>
     * 
     * @return The ARN of the FeatureTransformation object.
     */
    public final String featureTransformationArn() {
        return featureTransformationArn;
    }

    /**
     * <p>
     * The status of the recipe.
     * </p>
     * 
     * @return The status of the recipe.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The description of the recipe.
     * </p>
     * 
     * @return The description of the recipe.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time (in Unix format) that the recipe was created.
     * </p>
     * 
     * @return The date and time (in Unix format) that the recipe was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PERSONALIZED_RANKING
     * </p>
     * </li>
     * <li>
     * <p>
     * RELATED_ITEMS
     * </p>
     * </li>
     * <li>
     * <p>
     * USER_PERSONALIZATION
     * </p>
     * </li>
     * </ul>
     * 
     * @return One of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PERSONALIZED_RANKING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RELATED_ITEMS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USER_PERSONALIZATION
     *         </p>
     *         </li>
     */
    public final String recipeType() {
        return recipeType;
    }

    /**
     * <p>
     * The date and time (in Unix format) that the recipe was last updated.
     * </p>
     * 
     * @return The date and time (in Unix format) that the recipe was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(featureTransformationArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(recipeType());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recipe)) {
            return false;
        }
        Recipe other = (Recipe) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(recipeArn(), other.recipeArn())
                && Objects.equals(algorithmArn(), other.algorithmArn())
                && Objects.equals(featureTransformationArn(), other.featureTransformationArn())
                && Objects.equals(status(), other.status()) && Objects.equals(description(), other.description())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(recipeType(), other.recipeType())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Recipe").add("Name", name()).add("RecipeArn", recipeArn()).add("AlgorithmArn", algorithmArn())
                .add("FeatureTransformationArn", featureTransformationArn()).add("Status", status())
                .add("Description", description()).add("CreationDateTime", creationDateTime()).add("RecipeType", recipeType())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "recipeArn":
            return Optional.ofNullable(clazz.cast(recipeArn()));
        case "algorithmArn":
            return Optional.ofNullable(clazz.cast(algorithmArn()));
        case "featureTransformationArn":
            return Optional.ofNullable(clazz.cast(featureTransformationArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "recipeType":
            return Optional.ofNullable(clazz.cast(recipeType()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("recipeArn", RECIPE_ARN_FIELD);
        map.put("algorithmArn", ALGORITHM_ARN_FIELD);
        map.put("featureTransformationArn", FEATURE_TRANSFORMATION_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("recipeType", RECIPE_TYPE_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Recipe, T> g) {
        return obj -> g.apply((Recipe) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Recipe> {
        /**
         * <p>
         * The name of the recipe.
         * </p>
         * 
         * @param name
         *        The name of the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recipe.
         * </p>
         * 
         * @param recipeArn
         *        The Amazon Resource Name (ARN) of the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeArn(String recipeArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses to train the model.
         * </p>
         * 
         * @param algorithmArn
         *        The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses to train the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmArn(String algorithmArn);

        /**
         * <p>
         * The ARN of the FeatureTransformation object.
         * </p>
         * 
         * @param featureTransformationArn
         *        The ARN of the FeatureTransformation object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTransformationArn(String featureTransformationArn);

        /**
         * <p>
         * The status of the recipe.
         * </p>
         * 
         * @param status
         *        The status of the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The description of the recipe.
         * </p>
         * 
         * @param description
         *        The description of the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time (in Unix format) that the recipe was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time (in Unix format) that the recipe was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * One of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PERSONALIZED_RANKING
         * </p>
         * </li>
         * <li>
         * <p>
         * RELATED_ITEMS
         * </p>
         * </li>
         * <li>
         * <p>
         * USER_PERSONALIZATION
         * </p>
         * </li>
         * </ul>
         * 
         * @param recipeType
         *        One of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PERSONALIZED_RANKING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RELATED_ITEMS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USER_PERSONALIZATION
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeType(String recipeType);

        /**
         * <p>
         * The date and time (in Unix format) that the recipe was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time (in Unix format) that the recipe was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String recipeArn;

        private String algorithmArn;

        private String featureTransformationArn;

        private String status;

        private String description;

        private Instant creationDateTime;

        private String recipeType;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Recipe model) {
            name(model.name);
            recipeArn(model.recipeArn);
            algorithmArn(model.algorithmArn);
            featureTransformationArn(model.featureTransformationArn);
            status(model.status);
            description(model.description);
            creationDateTime(model.creationDateTime);
            recipeType(model.recipeType);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecipeArn() {
            return recipeArn;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        @Override
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final String getAlgorithmArn() {
            return algorithmArn;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final String getFeatureTransformationArn() {
            return featureTransformationArn;
        }

        public final void setFeatureTransformationArn(String featureTransformationArn) {
            this.featureTransformationArn = featureTransformationArn;
        }

        @Override
        public final Builder featureTransformationArn(String featureTransformationArn) {
            this.featureTransformationArn = featureTransformationArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getRecipeType() {
            return recipeType;
        }

        public final void setRecipeType(String recipeType) {
            this.recipeType = recipeType;
        }

        @Override
        public final Builder recipeType(String recipeType) {
            this.recipeType = recipeType;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public Recipe build() {
            return new Recipe(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
