/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.CampaignSummary;
import software.amazon.awssdk.services.personalize.model.CampaignsCopier;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCampaignsResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListCampaignsResponse> {
    private static final SdkField<List<CampaignSummary>> CAMPAIGNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("campaigns").getter(ListCampaignsResponse.getter(ListCampaignsResponse::campaigns)).setter(ListCampaignsResponse.setter(Builder::campaigns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaigns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CampaignSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCampaignsResponse.getter(ListCampaignsResponse::nextToken)).setter(ListCampaignsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGNS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCampaignsResponse.memberNameToFieldInitializer();
    private final List<CampaignSummary> campaigns;
    private final String nextToken;

    private ListCampaignsResponse(BuilderImpl builder) {
        super(builder);
        this.campaigns = builder.campaigns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCampaigns() {
        return this.campaigns != null && !(this.campaigns instanceof SdkAutoConstructList);
    }

    public final List<CampaignSummary> campaigns() {
        return this.campaigns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCampaigns() ? this.campaigns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCampaignsResponse)) {
            return false;
        }
        ListCampaignsResponse other = (ListCampaignsResponse)((Object)obj);
        return this.hasCampaigns() == other.hasCampaigns() && Objects.equals(this.campaigns(), other.campaigns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCampaignsResponse").add("Campaigns", this.hasCampaigns() ? this.campaigns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "campaigns": {
                return Optional.ofNullable(clazz.cast(this.campaigns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("campaigns", CAMPAIGNS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCampaignsResponse, T> g) {
        return obj -> g.apply((ListCampaignsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<CampaignSummary> campaigns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCampaignsResponse model) {
            super(model);
            this.campaigns(model.campaigns);
            this.nextToken(model.nextToken);
        }

        public final List<CampaignSummary.Builder> getCampaigns() {
            List<CampaignSummary.Builder> result = CampaignsCopier.copyToBuilder(this.campaigns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCampaigns(Collection<CampaignSummary.BuilderImpl> campaigns) {
            this.campaigns = CampaignsCopier.copyFromBuilder(campaigns);
        }

        @Override
        public final Builder campaigns(Collection<CampaignSummary> campaigns) {
            this.campaigns = CampaignsCopier.copy(campaigns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder campaigns(CampaignSummary ... campaigns) {
            this.campaigns(Arrays.asList(campaigns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder campaigns(Consumer<CampaignSummary.Builder> ... campaigns) {
            this.campaigns(Stream.of(campaigns).map(c -> (CampaignSummary)((CampaignSummary.Builder)CampaignSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCampaignsResponse build() {
            return new ListCampaignsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCampaignsResponse> {
        public Builder campaigns(Collection<CampaignSummary> var1);

        public Builder campaigns(CampaignSummary ... var1);

        public Builder campaigns(Consumer<CampaignSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

