/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.DatasetSchemaSummary;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.services.personalize.model.SchemasCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSchemasResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListSchemasResponse> {
    private static final SdkField<List<DatasetSchemaSummary>> SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("schemas").getter(ListSchemasResponse.getter(ListSchemasResponse::schemas)).setter(ListSchemasResponse.setter(Builder::schemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetSchemaSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSchemasResponse.getter(ListSchemasResponse::nextToken)).setter(ListSchemasResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMAS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSchemasResponse.memberNameToFieldInitializer();
    private final List<DatasetSchemaSummary> schemas;
    private final String nextToken;

    private ListSchemasResponse(BuilderImpl builder) {
        super(builder);
        this.schemas = builder.schemas;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSchemas() {
        return this.schemas != null && !(this.schemas instanceof SdkAutoConstructList);
    }

    public final List<DatasetSchemaSummary> schemas() {
        return this.schemas;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemas() ? this.schemas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemasResponse)) {
            return false;
        }
        ListSchemasResponse other = (ListSchemasResponse)((Object)obj);
        return this.hasSchemas() == other.hasSchemas() && Objects.equals(this.schemas(), other.schemas()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSchemasResponse").add("Schemas", this.hasSchemas() ? this.schemas() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schemas": {
                return Optional.ofNullable(clazz.cast(this.schemas()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("schemas", SCHEMAS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSchemasResponse, T> g) {
        return obj -> g.apply((ListSchemasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<DatasetSchemaSummary> schemas = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemasResponse model) {
            super(model);
            this.schemas(model.schemas);
            this.nextToken(model.nextToken);
        }

        public final List<DatasetSchemaSummary.Builder> getSchemas() {
            List<DatasetSchemaSummary.Builder> result = SchemasCopier.copyToBuilder(this.schemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemas(Collection<DatasetSchemaSummary.BuilderImpl> schemas) {
            this.schemas = SchemasCopier.copyFromBuilder(schemas);
        }

        @Override
        public final Builder schemas(Collection<DatasetSchemaSummary> schemas) {
            this.schemas = SchemasCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(DatasetSchemaSummary ... schemas) {
            this.schemas(Arrays.asList(schemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Consumer<DatasetSchemaSummary.Builder> ... schemas) {
            this.schemas(Stream.of(schemas).map(c -> (DatasetSchemaSummary)((DatasetSchemaSummary.Builder)DatasetSchemaSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSchemasResponse build() {
            return new ListSchemasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSchemasResponse> {
        public Builder schemas(Collection<DatasetSchemaSummary> var1);

        public Builder schemas(DatasetSchemaSummary ... var1);

        public Builder schemas(Consumer<DatasetSchemaSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

