/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.HPOObjective;
import software.amazon.awssdk.services.personalize.model.HPOResourceConfig;
import software.amazon.awssdk.services.personalize.model.HyperParameterRanges;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HPOConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HPOConfig> {
    private static final SdkField<HPOObjective> HPO_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hpoObjective").getter(HPOConfig.getter(HPOConfig::hpoObjective)).setter(HPOConfig.setter(Builder::hpoObjective)).constructor(HPOObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hpoObjective").build()}).build();
    private static final SdkField<HPOResourceConfig> HPO_RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hpoResourceConfig").getter(HPOConfig.getter(HPOConfig::hpoResourceConfig)).setter(HPOConfig.setter(Builder::hpoResourceConfig)).constructor(HPOResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hpoResourceConfig").build()}).build();
    private static final SdkField<HyperParameterRanges> ALGORITHM_HYPER_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("algorithmHyperParameterRanges").getter(HPOConfig.getter(HPOConfig::algorithmHyperParameterRanges)).setter(HPOConfig.setter(Builder::algorithmHyperParameterRanges)).constructor(HyperParameterRanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmHyperParameterRanges").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HPO_OBJECTIVE_FIELD, HPO_RESOURCE_CONFIG_FIELD, ALGORITHM_HYPER_PARAMETER_RANGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HPOConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final HPOObjective hpoObjective;
    private final HPOResourceConfig hpoResourceConfig;
    private final HyperParameterRanges algorithmHyperParameterRanges;

    private HPOConfig(BuilderImpl builder) {
        this.hpoObjective = builder.hpoObjective;
        this.hpoResourceConfig = builder.hpoResourceConfig;
        this.algorithmHyperParameterRanges = builder.algorithmHyperParameterRanges;
    }

    public final HPOObjective hpoObjective() {
        return this.hpoObjective;
    }

    public final HPOResourceConfig hpoResourceConfig() {
        return this.hpoResourceConfig;
    }

    public final HyperParameterRanges algorithmHyperParameterRanges() {
        return this.algorithmHyperParameterRanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hpoObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.hpoResourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmHyperParameterRanges());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HPOConfig)) {
            return false;
        }
        HPOConfig other = (HPOConfig)obj;
        return Objects.equals(this.hpoObjective(), other.hpoObjective()) && Objects.equals(this.hpoResourceConfig(), other.hpoResourceConfig()) && Objects.equals(this.algorithmHyperParameterRanges(), other.algorithmHyperParameterRanges());
    }

    public final String toString() {
        return ToString.builder((String)"HPOConfig").add("HpoObjective", (Object)this.hpoObjective()).add("HpoResourceConfig", (Object)this.hpoResourceConfig()).add("AlgorithmHyperParameterRanges", (Object)this.algorithmHyperParameterRanges()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hpoObjective": {
                return Optional.ofNullable(clazz.cast(this.hpoObjective()));
            }
            case "hpoResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.hpoResourceConfig()));
            }
            case "algorithmHyperParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.algorithmHyperParameterRanges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hpoObjective", HPO_OBJECTIVE_FIELD);
        map.put("hpoResourceConfig", HPO_RESOURCE_CONFIG_FIELD);
        map.put("algorithmHyperParameterRanges", ALGORITHM_HYPER_PARAMETER_RANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HPOConfig, T> g) {
        return obj -> g.apply((HPOConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HPOObjective hpoObjective;
        private HPOResourceConfig hpoResourceConfig;
        private HyperParameterRanges algorithmHyperParameterRanges;

        private BuilderImpl() {
        }

        private BuilderImpl(HPOConfig model) {
            this.hpoObjective(model.hpoObjective);
            this.hpoResourceConfig(model.hpoResourceConfig);
            this.algorithmHyperParameterRanges(model.algorithmHyperParameterRanges);
        }

        public final HPOObjective.Builder getHpoObjective() {
            return this.hpoObjective != null ? this.hpoObjective.toBuilder() : null;
        }

        public final void setHpoObjective(HPOObjective.BuilderImpl hpoObjective) {
            this.hpoObjective = hpoObjective != null ? hpoObjective.build() : null;
        }

        @Override
        public final Builder hpoObjective(HPOObjective hpoObjective) {
            this.hpoObjective = hpoObjective;
            return this;
        }

        public final HPOResourceConfig.Builder getHpoResourceConfig() {
            return this.hpoResourceConfig != null ? this.hpoResourceConfig.toBuilder() : null;
        }

        public final void setHpoResourceConfig(HPOResourceConfig.BuilderImpl hpoResourceConfig) {
            this.hpoResourceConfig = hpoResourceConfig != null ? hpoResourceConfig.build() : null;
        }

        @Override
        public final Builder hpoResourceConfig(HPOResourceConfig hpoResourceConfig) {
            this.hpoResourceConfig = hpoResourceConfig;
            return this;
        }

        public final HyperParameterRanges.Builder getAlgorithmHyperParameterRanges() {
            return this.algorithmHyperParameterRanges != null ? this.algorithmHyperParameterRanges.toBuilder() : null;
        }

        public final void setAlgorithmHyperParameterRanges(HyperParameterRanges.BuilderImpl algorithmHyperParameterRanges) {
            this.algorithmHyperParameterRanges = algorithmHyperParameterRanges != null ? algorithmHyperParameterRanges.build() : null;
        }

        @Override
        public final Builder algorithmHyperParameterRanges(HyperParameterRanges algorithmHyperParameterRanges) {
            this.algorithmHyperParameterRanges = algorithmHyperParameterRanges;
            return this;
        }

        public HPOConfig build() {
            return new HPOConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HPOConfig> {
        public Builder hpoObjective(HPOObjective var1);

        default public Builder hpoObjective(Consumer<HPOObjective.Builder> hpoObjective) {
            return this.hpoObjective((HPOObjective)((HPOObjective.Builder)HPOObjective.builder().applyMutation(hpoObjective)).build());
        }

        public Builder hpoResourceConfig(HPOResourceConfig var1);

        default public Builder hpoResourceConfig(Consumer<HPOResourceConfig.Builder> hpoResourceConfig) {
            return this.hpoResourceConfig((HPOResourceConfig)((HPOResourceConfig.Builder)HPOResourceConfig.builder().applyMutation(hpoResourceConfig)).build());
        }

        public Builder algorithmHyperParameterRanges(HyperParameterRanges var1);

        default public Builder algorithmHyperParameterRanges(Consumer<HyperParameterRanges.Builder> algorithmHyperParameterRanges) {
            return this.algorithmHyperParameterRanges((HyperParameterRanges)((HyperParameterRanges.Builder)HyperParameterRanges.builder().applyMutation(algorithmHyperParameterRanges)).build());
        }
    }
}

