/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.ObjectiveSensitivity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptimizationObjective
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptimizationObjective> {
    private static final SdkField<String> ITEM_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("itemAttribute").getter(OptimizationObjective.getter(OptimizationObjective::itemAttribute)).setter(OptimizationObjective.setter(Builder::itemAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemAttribute").build()}).build();
    private static final SdkField<String> OBJECTIVE_SENSITIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objectiveSensitivity").getter(OptimizationObjective.getter(OptimizationObjective::objectiveSensitivityAsString)).setter(OptimizationObjective.setter(Builder::objectiveSensitivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectiveSensitivity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_ATTRIBUTE_FIELD, OBJECTIVE_SENSITIVITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("itemAttribute", ITEM_ATTRIBUTE_FIELD);
            this.put("objectiveSensitivity", OBJECTIVE_SENSITIVITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String itemAttribute;
    private final String objectiveSensitivity;

    private OptimizationObjective(BuilderImpl builder) {
        this.itemAttribute = builder.itemAttribute;
        this.objectiveSensitivity = builder.objectiveSensitivity;
    }

    public final String itemAttribute() {
        return this.itemAttribute;
    }

    public final ObjectiveSensitivity objectiveSensitivity() {
        return ObjectiveSensitivity.fromValue(this.objectiveSensitivity);
    }

    public final String objectiveSensitivityAsString() {
        return this.objectiveSensitivity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.itemAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectiveSensitivityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationObjective)) {
            return false;
        }
        OptimizationObjective other = (OptimizationObjective)obj;
        return Objects.equals(this.itemAttribute(), other.itemAttribute()) && Objects.equals(this.objectiveSensitivityAsString(), other.objectiveSensitivityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OptimizationObjective").add("ItemAttribute", (Object)this.itemAttribute()).add("ObjectiveSensitivity", (Object)this.objectiveSensitivityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "itemAttribute": {
                return Optional.ofNullable(clazz.cast(this.itemAttribute()));
            }
            case "objectiveSensitivity": {
                return Optional.ofNullable(clazz.cast(this.objectiveSensitivityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OptimizationObjective, T> g) {
        return obj -> g.apply((OptimizationObjective)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String itemAttribute;
        private String objectiveSensitivity;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationObjective model) {
            this.itemAttribute(model.itemAttribute);
            this.objectiveSensitivity(model.objectiveSensitivity);
        }

        public final String getItemAttribute() {
            return this.itemAttribute;
        }

        public final void setItemAttribute(String itemAttribute) {
            this.itemAttribute = itemAttribute;
        }

        @Override
        public final Builder itemAttribute(String itemAttribute) {
            this.itemAttribute = itemAttribute;
            return this;
        }

        public final String getObjectiveSensitivity() {
            return this.objectiveSensitivity;
        }

        public final void setObjectiveSensitivity(String objectiveSensitivity) {
            this.objectiveSensitivity = objectiveSensitivity;
        }

        @Override
        public final Builder objectiveSensitivity(String objectiveSensitivity) {
            this.objectiveSensitivity = objectiveSensitivity;
            return this;
        }

        @Override
        public final Builder objectiveSensitivity(ObjectiveSensitivity objectiveSensitivity) {
            this.objectiveSensitivity(objectiveSensitivity == null ? null : objectiveSensitivity.toString());
            return this;
        }

        public OptimizationObjective build() {
            return new OptimizationObjective(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptimizationObjective> {
        public Builder itemAttribute(String var1);

        public Builder objectiveSensitivity(String var1);

        public Builder objectiveSensitivity(ObjectiveSensitivity var1);
    }
}

