/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.PersonalizeServiceClientConfiguration;
import software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateBatchInferenceJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateBatchSegmentJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateCampaignRequest;
import software.amazon.awssdk.services.personalize.model.CreateCampaignResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetExportJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetGroupRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetGroupResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobResponse;
import software.amazon.awssdk.services.personalize.model.CreateDatasetRequest;
import software.amazon.awssdk.services.personalize.model.CreateDatasetResponse;
import software.amazon.awssdk.services.personalize.model.CreateEventTrackerRequest;
import software.amazon.awssdk.services.personalize.model.CreateEventTrackerResponse;
import software.amazon.awssdk.services.personalize.model.CreateFilterRequest;
import software.amazon.awssdk.services.personalize.model.CreateFilterResponse;
import software.amazon.awssdk.services.personalize.model.CreateMetricAttributionRequest;
import software.amazon.awssdk.services.personalize.model.CreateMetricAttributionResponse;
import software.amazon.awssdk.services.personalize.model.CreateRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.CreateRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.CreateSchemaRequest;
import software.amazon.awssdk.services.personalize.model.CreateSchemaResponse;
import software.amazon.awssdk.services.personalize.model.CreateSolutionRequest;
import software.amazon.awssdk.services.personalize.model.CreateSolutionResponse;
import software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest;
import software.amazon.awssdk.services.personalize.model.CreateSolutionVersionResponse;
import software.amazon.awssdk.services.personalize.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.personalize.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupRequest;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetGroupResponse;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.personalize.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.personalize.model.DeleteEventTrackerRequest;
import software.amazon.awssdk.services.personalize.model.DeleteEventTrackerResponse;
import software.amazon.awssdk.services.personalize.model.DeleteFilterRequest;
import software.amazon.awssdk.services.personalize.model.DeleteFilterResponse;
import software.amazon.awssdk.services.personalize.model.DeleteMetricAttributionRequest;
import software.amazon.awssdk.services.personalize.model.DeleteMetricAttributionResponse;
import software.amazon.awssdk.services.personalize.model.DeleteRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.DeleteRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.personalize.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.personalize.model.DeleteSolutionRequest;
import software.amazon.awssdk.services.personalize.model.DeleteSolutionResponse;
import software.amazon.awssdk.services.personalize.model.DescribeAlgorithmRequest;
import software.amazon.awssdk.services.personalize.model.DescribeAlgorithmResponse;
import software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeBatchInferenceJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeCampaignRequest;
import software.amazon.awssdk.services.personalize.model.DescribeCampaignResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetExportJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetGroupResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobResponse;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.personalize.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.personalize.model.DescribeEventTrackerRequest;
import software.amazon.awssdk.services.personalize.model.DescribeEventTrackerResponse;
import software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationRequest;
import software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationResponse;
import software.amazon.awssdk.services.personalize.model.DescribeFilterRequest;
import software.amazon.awssdk.services.personalize.model.DescribeFilterResponse;
import software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionRequest;
import software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionResponse;
import software.amazon.awssdk.services.personalize.model.DescribeRecipeRequest;
import software.amazon.awssdk.services.personalize.model.DescribeRecipeResponse;
import software.amazon.awssdk.services.personalize.model.DescribeRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.DescribeRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.DescribeSchemaRequest;
import software.amazon.awssdk.services.personalize.model.DescribeSchemaResponse;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionRequest;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionRequest;
import software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionResponse;
import software.amazon.awssdk.services.personalize.model.GetSolutionMetricsRequest;
import software.amazon.awssdk.services.personalize.model.GetSolutionMetricsResponse;
import software.amazon.awssdk.services.personalize.model.InvalidInputException;
import software.amazon.awssdk.services.personalize.model.InvalidNextTokenException;
import software.amazon.awssdk.services.personalize.model.LimitExceededException;
import software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListBatchSegmentJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListCampaignsRequest;
import software.amazon.awssdk.services.personalize.model.ListCampaignsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetGroupsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetGroupsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetImportJobsResponse;
import software.amazon.awssdk.services.personalize.model.ListDatasetsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetsResponse;
import software.amazon.awssdk.services.personalize.model.ListEventTrackersRequest;
import software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse;
import software.amazon.awssdk.services.personalize.model.ListFiltersRequest;
import software.amazon.awssdk.services.personalize.model.ListFiltersResponse;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsRequest;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionMetricsResponse;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionsRequest;
import software.amazon.awssdk.services.personalize.model.ListMetricAttributionsResponse;
import software.amazon.awssdk.services.personalize.model.ListRecipesRequest;
import software.amazon.awssdk.services.personalize.model.ListRecipesResponse;
import software.amazon.awssdk.services.personalize.model.ListRecommendersRequest;
import software.amazon.awssdk.services.personalize.model.ListRecommendersResponse;
import software.amazon.awssdk.services.personalize.model.ListSchemasRequest;
import software.amazon.awssdk.services.personalize.model.ListSchemasResponse;
import software.amazon.awssdk.services.personalize.model.ListSolutionVersionsRequest;
import software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse;
import software.amazon.awssdk.services.personalize.model.ListSolutionsRequest;
import software.amazon.awssdk.services.personalize.model.ListSolutionsResponse;
import software.amazon.awssdk.services.personalize.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.personalize.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.personalize.model.PersonalizeException;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.services.personalize.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.personalize.model.ResourceInUseException;
import software.amazon.awssdk.services.personalize.model.ResourceNotFoundException;
import software.amazon.awssdk.services.personalize.model.StartRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.StartRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.StopRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.StopRecommenderResponse;
import software.amazon.awssdk.services.personalize.model.StopSolutionVersionCreationRequest;
import software.amazon.awssdk.services.personalize.model.StopSolutionVersionCreationResponse;
import software.amazon.awssdk.services.personalize.model.TagResourceRequest;
import software.amazon.awssdk.services.personalize.model.TagResourceResponse;
import software.amazon.awssdk.services.personalize.model.TooManyTagKeysException;
import software.amazon.awssdk.services.personalize.model.TooManyTagsException;
import software.amazon.awssdk.services.personalize.model.UntagResourceRequest;
import software.amazon.awssdk.services.personalize.model.UntagResourceResponse;
import software.amazon.awssdk.services.personalize.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.personalize.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionRequest;
import software.amazon.awssdk.services.personalize.model.UpdateMetricAttributionResponse;
import software.amazon.awssdk.services.personalize.model.UpdateRecommenderRequest;
import software.amazon.awssdk.services.personalize.model.UpdateRecommenderResponse;
import software.amazon.awssdk.services.personalize.paginators.ListBatchInferenceJobsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListBatchSegmentJobsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListCampaignsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListDatasetExportJobsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListDatasetGroupsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListDatasetImportJobsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListDatasetsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListEventTrackersIterable;
import software.amazon.awssdk.services.personalize.paginators.ListFiltersIterable;
import software.amazon.awssdk.services.personalize.paginators.ListMetricAttributionMetricsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListMetricAttributionsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListRecipesIterable;
import software.amazon.awssdk.services.personalize.paginators.ListRecommendersIterable;
import software.amazon.awssdk.services.personalize.paginators.ListSchemasIterable;
import software.amazon.awssdk.services.personalize.paginators.ListSolutionVersionsIterable;
import software.amazon.awssdk.services.personalize.paginators.ListSolutionsIterable;
import software.amazon.awssdk.services.personalize.transform.CreateBatchInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateBatchSegmentJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateDatasetExportJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateDatasetGroupRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateDatasetImportJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateDatasetRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateEventTrackerRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateFilterRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateMetricAttributionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateRecommenderRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateSchemaRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateSolutionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.CreateSolutionVersionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteDatasetGroupRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteDatasetRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteEventTrackerRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteFilterRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteMetricAttributionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteRecommenderRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteSchemaRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DeleteSolutionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeAlgorithmRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeBatchInferenceJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeBatchSegmentJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeCampaignRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeDatasetExportJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeDatasetGroupRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeDatasetImportJobRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeEventTrackerRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeFeatureTransformationRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeFilterRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeMetricAttributionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeRecipeRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeRecommenderRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeSchemaRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeSolutionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.DescribeSolutionVersionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.GetSolutionMetricsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListBatchInferenceJobsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListBatchSegmentJobsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListCampaignsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListDatasetExportJobsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListDatasetGroupsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListDatasetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListEventTrackersRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListFiltersRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListMetricAttributionMetricsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListMetricAttributionsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListRecipesRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListRecommendersRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListSchemasRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListSolutionVersionsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListSolutionsRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.StartRecommenderRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.StopRecommenderRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.StopSolutionVersionCreationRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.UpdateCampaignRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.UpdateMetricAttributionRequestMarshaller;
import software.amazon.awssdk.services.personalize.transform.UpdateRecommenderRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultPersonalizeClient
implements PersonalizeClient {
    private static final Logger log = Logger.loggerFor(DefaultPersonalizeClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final PersonalizeServiceClientConfiguration serviceClientConfiguration;

    protected DefaultPersonalizeClient(PersonalizeServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBatchInferenceJobResponse createBatchInferenceJob(CreateBatchInferenceJobRequest createBatchInferenceJobRequest) throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, ResourceNotFoundException, ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBatchInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createBatchInferenceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBatchInferenceJob");
            CreateBatchInferenceJobResponse createBatchInferenceJobResponse = (CreateBatchInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBatchInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBatchInferenceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBatchInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBatchInferenceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createBatchInferenceJob$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBatchSegmentJobResponse createBatchSegmentJob(CreateBatchSegmentJobRequest createBatchSegmentJobRequest) throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, ResourceNotFoundException, ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBatchSegmentJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createBatchSegmentJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBatchSegmentJob");
            CreateBatchSegmentJobResponse createBatchSegmentJobResponse = (CreateBatchSegmentJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBatchSegmentJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBatchSegmentJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBatchSegmentJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBatchSegmentJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createBatchSegmentJob$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws InvalidInputException, ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCampaign");
            CreateCampaignResponse createCampaignResponse = (CreateCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCampaignRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCampaignResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createCampaign$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws InvalidInputException, ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataset");
            CreateDatasetResponse createDatasetResponse = (CreateDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createDataset$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatasetExportJobResponse createDatasetExportJob(CreateDatasetExportJobRequest createDatasetExportJobRequest) throws InvalidInputException, ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createDatasetExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatasetExportJob");
            CreateDatasetExportJobResponse createDatasetExportJobResponse = (CreateDatasetExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatasetExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatasetExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatasetExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatasetExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createDatasetExportJob$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatasetGroupResponse createDatasetGroup(CreateDatasetGroupRequest createDatasetGroupRequest) throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createDatasetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatasetGroup");
            CreateDatasetGroupResponse createDatasetGroupResponse = (CreateDatasetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatasetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatasetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatasetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatasetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createDatasetGroup$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatasetImportJobResponse createDatasetImportJob(CreateDatasetImportJobRequest createDatasetImportJobRequest) throws InvalidInputException, ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createDatasetImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDatasetImportJob");
            CreateDatasetImportJobResponse createDatasetImportJobResponse = (CreateDatasetImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDatasetImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDatasetImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatasetImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatasetImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createDatasetImportJob$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEventTrackerResponse createEventTracker(CreateEventTrackerRequest createEventTrackerRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventTrackerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createEventTrackerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventTracker");
            CreateEventTrackerResponse createEventTrackerResponse = (CreateEventTrackerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventTracker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEventTrackerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEventTrackerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEventTrackerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createEventTracker$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFilterResponse createFilter(CreateFilterRequest createFilterRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFilter");
            CreateFilterResponse createFilterResponse = (CreateFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createFilter$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMetricAttributionResponse createMetricAttribution(CreateMetricAttributionRequest createMetricAttributionRequest) throws InvalidInputException, ResourceNotFoundException, ResourceAlreadyExistsException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMetricAttributionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createMetricAttributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMetricAttribution");
            CreateMetricAttributionResponse createMetricAttributionResponse = (CreateMetricAttributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMetricAttribution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMetricAttributionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMetricAttributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMetricAttributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createMetricAttribution$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRecommenderResponse createRecommender(CreateRecommenderRequest createRecommenderRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRecommenderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createRecommenderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRecommender");
            CreateRecommenderResponse createRecommenderResponse = (CreateRecommenderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRecommender").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRecommenderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRecommenderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRecommenderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createRecommender$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSchemaResponse createSchema(CreateSchemaRequest createSchemaRequest) throws InvalidInputException, ResourceAlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSchemaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSchema");
            CreateSchemaResponse createSchemaResponse = (CreateSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSchema").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createSchema$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSolutionResponse createSolution(CreateSolutionRequest createSolutionRequest) throws InvalidInputException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, ResourceInUseException, TooManyTagsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSolutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createSolutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSolution");
            CreateSolutionResponse createSolutionResponse = (CreateSolutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSolution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSolutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSolutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSolutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createSolution$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSolutionVersionResponse createSolutionVersion(CreateSolutionVersionRequest createSolutionVersionRequest) throws InvalidInputException, ResourceNotFoundException, LimitExceededException, ResourceInUseException, TooManyTagsException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSolutionVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, createSolutionVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSolutionVersion");
            CreateSolutionVersionResponse createSolutionVersionResponse = (CreateSolutionVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSolutionVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSolutionVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSolutionVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSolutionVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$createSolutionVersion$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, deleteCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCampaign");
            DeleteCampaignResponse deleteCampaignResponse = (DeleteCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCampaignRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCampaignResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$deleteCampaign$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, deleteDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataset");
            DeleteDatasetResponse deleteDatasetResponse = (DeleteDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$deleteDataset$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDatasetGroupResponse deleteDatasetGroup(DeleteDatasetGroupRequest deleteDatasetGroupRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, deleteDatasetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDatasetGroup");
            DeleteDatasetGroupResponse deleteDatasetGroupResponse = (DeleteDatasetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDatasetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatasetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDatasetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDatasetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$deleteDatasetGroup$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventTrackerResponse deleteEventTracker(DeleteEventTrackerRequest deleteEventTrackerRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventTrackerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, deleteEventTrackerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventTracker");
            DeleteEventTrackerResponse deleteEventTrackerResponse = (DeleteEventTrackerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventTracker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEventTrackerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEventTrackerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEventTrackerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$deleteEventTracker$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFilterResponse deleteFilter(DeleteFilterRequest deleteFilterRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, deleteFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFilter");
            DeleteFilterResponse deleteFilterResponse = (DeleteFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$deleteFilter$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMetricAttributionResponse deleteMetricAttribution(DeleteMetricAttributionRequest deleteMetricAttributionRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMetricAttributionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, deleteMetricAttributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMetricAttribution");
            DeleteMetricAttributionResponse deleteMetricAttributionResponse = (DeleteMetricAttributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMetricAttribution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMetricAttributionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMetricAttributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMetricAttributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$deleteMetricAttribution$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRecommenderResponse deleteRecommender(DeleteRecommenderRequest deleteRecommenderRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRecommenderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, deleteRecommenderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRecommender");
            DeleteRecommenderResponse deleteRecommenderResponse = (DeleteRecommenderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRecommender").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRecommenderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRecommenderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRecommenderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$deleteRecommender$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSchemaResponse deleteSchema(DeleteSchemaRequest deleteSchemaRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSchemaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, deleteSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSchema");
            DeleteSchemaResponse deleteSchemaResponse = (DeleteSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSchema").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$deleteSchema$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSolutionResponse deleteSolution(DeleteSolutionRequest deleteSolutionRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSolutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, deleteSolutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSolution");
            DeleteSolutionResponse deleteSolutionResponse = (DeleteSolutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSolution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSolutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSolutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSolutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$deleteSolution$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlgorithmResponse describeAlgorithm(DescribeAlgorithmRequest describeAlgorithmRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAlgorithmResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeAlgorithmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAlgorithm");
            DescribeAlgorithmResponse describeAlgorithmResponse = (DescribeAlgorithmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlgorithm").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAlgorithmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAlgorithmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAlgorithmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeAlgorithm$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBatchInferenceJobResponse describeBatchInferenceJob(DescribeBatchInferenceJobRequest describeBatchInferenceJobRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBatchInferenceJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeBatchInferenceJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBatchInferenceJob");
            DescribeBatchInferenceJobResponse describeBatchInferenceJobResponse = (DescribeBatchInferenceJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBatchInferenceJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBatchInferenceJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBatchInferenceJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBatchInferenceJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeBatchInferenceJob$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBatchSegmentJobResponse describeBatchSegmentJob(DescribeBatchSegmentJobRequest describeBatchSegmentJobRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBatchSegmentJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeBatchSegmentJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBatchSegmentJob");
            DescribeBatchSegmentJobResponse describeBatchSegmentJobResponse = (DescribeBatchSegmentJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBatchSegmentJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBatchSegmentJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBatchSegmentJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBatchSegmentJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeBatchSegmentJob$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCampaignResponse describeCampaign(DescribeCampaignRequest describeCampaignRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCampaign");
            DescribeCampaignResponse describeCampaignResponse = (DescribeCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCampaignRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCampaignResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeCampaign$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataset");
            DescribeDatasetResponse describeDatasetResponse = (DescribeDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeDataset$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetExportJobResponse describeDatasetExportJob(DescribeDatasetExportJobRequest describeDatasetExportJobRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeDatasetExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDatasetExportJob");
            DescribeDatasetExportJobResponse describeDatasetExportJobResponse = (DescribeDatasetExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDatasetExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatasetExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDatasetExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDatasetExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeDatasetExportJob$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetGroupResponse describeDatasetGroup(DescribeDatasetGroupRequest describeDatasetGroupRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeDatasetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDatasetGroup");
            DescribeDatasetGroupResponse describeDatasetGroupResponse = (DescribeDatasetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDatasetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatasetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDatasetGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDatasetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeDatasetGroup$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetImportJobResponse describeDatasetImportJob(DescribeDatasetImportJobRequest describeDatasetImportJobRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeDatasetImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDatasetImportJob");
            DescribeDatasetImportJobResponse describeDatasetImportJobResponse = (DescribeDatasetImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDatasetImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatasetImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDatasetImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDatasetImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeDatasetImportJob$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventTrackerResponse describeEventTracker(DescribeEventTrackerRequest describeEventTrackerRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventTrackerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeEventTrackerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventTracker");
            DescribeEventTrackerResponse describeEventTrackerResponse = (DescribeEventTrackerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventTracker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventTrackerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventTrackerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventTrackerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeEventTracker$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFeatureTransformationResponse describeFeatureTransformation(DescribeFeatureTransformationRequest describeFeatureTransformationRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFeatureTransformationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeFeatureTransformationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFeatureTransformation");
            DescribeFeatureTransformationResponse describeFeatureTransformationResponse = (DescribeFeatureTransformationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFeatureTransformation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFeatureTransformationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFeatureTransformationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFeatureTransformationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeFeatureTransformation$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFilterResponse describeFilter(DescribeFilterRequest describeFilterRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFilter");
            DescribeFilterResponse describeFilterResponse = (DescribeFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeFilter$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMetricAttributionResponse describeMetricAttribution(DescribeMetricAttributionRequest describeMetricAttributionRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMetricAttributionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeMetricAttributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMetricAttribution");
            DescribeMetricAttributionResponse describeMetricAttributionResponse = (DescribeMetricAttributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMetricAttribution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeMetricAttributionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMetricAttributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMetricAttributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeMetricAttribution$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRecipeResponse describeRecipe(DescribeRecipeRequest describeRecipeRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRecipeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeRecipeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRecipe");
            DescribeRecipeResponse describeRecipeResponse = (DescribeRecipeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRecipe").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRecipeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRecipeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRecipeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeRecipe$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRecommenderResponse describeRecommender(DescribeRecommenderRequest describeRecommenderRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRecommenderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeRecommenderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRecommender");
            DescribeRecommenderResponse describeRecommenderResponse = (DescribeRecommenderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRecommender").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRecommenderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRecommenderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRecommenderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeRecommender$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSchemaResponse describeSchema(DescribeSchemaRequest describeSchemaRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSchemaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSchema");
            DescribeSchemaResponse describeSchemaResponse = (DescribeSchemaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSchema").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSchemaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSchemaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeSchema$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSolutionResponse describeSolution(DescribeSolutionRequest describeSolutionRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSolutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeSolutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSolution");
            DescribeSolutionResponse describeSolutionResponse = (DescribeSolutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSolution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSolutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSolutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSolutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeSolution$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSolutionVersionResponse describeSolutionVersion(DescribeSolutionVersionRequest describeSolutionVersionRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSolutionVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, describeSolutionVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSolutionVersion");
            DescribeSolutionVersionResponse describeSolutionVersionResponse = (DescribeSolutionVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSolutionVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSolutionVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSolutionVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSolutionVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$describeSolutionVersion$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSolutionMetricsResponse getSolutionMetrics(GetSolutionMetricsRequest getSolutionMetricsRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSolutionMetricsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, getSolutionMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSolutionMetrics");
            GetSolutionMetricsResponse getSolutionMetricsResponse = (GetSolutionMetricsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSolutionMetrics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSolutionMetricsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSolutionMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSolutionMetricsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$getSolutionMetrics$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBatchInferenceJobsResponse listBatchInferenceJobs(ListBatchInferenceJobsRequest listBatchInferenceJobsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBatchInferenceJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listBatchInferenceJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBatchInferenceJobs");
            ListBatchInferenceJobsResponse listBatchInferenceJobsResponse = (ListBatchInferenceJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBatchInferenceJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBatchInferenceJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBatchInferenceJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBatchInferenceJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listBatchInferenceJobs$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListBatchInferenceJobsIterable listBatchInferenceJobsPaginator(ListBatchInferenceJobsRequest listBatchInferenceJobsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListBatchInferenceJobsIterable(this, this.applyPaginatorUserAgent(listBatchInferenceJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBatchSegmentJobsResponse listBatchSegmentJobs(ListBatchSegmentJobsRequest listBatchSegmentJobsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBatchSegmentJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listBatchSegmentJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBatchSegmentJobs");
            ListBatchSegmentJobsResponse listBatchSegmentJobsResponse = (ListBatchSegmentJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBatchSegmentJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBatchSegmentJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBatchSegmentJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBatchSegmentJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listBatchSegmentJobs$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListBatchSegmentJobsIterable listBatchSegmentJobsPaginator(ListBatchSegmentJobsRequest listBatchSegmentJobsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListBatchSegmentJobsIterable(this, this.applyPaginatorUserAgent(listBatchSegmentJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCampaignsResponse listCampaigns(ListCampaignsRequest listCampaignsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCampaignsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listCampaignsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCampaigns");
            ListCampaignsResponse listCampaignsResponse = (ListCampaignsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCampaigns").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCampaignsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCampaignsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCampaignsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listCampaigns$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCampaignsIterable listCampaignsPaginator(ListCampaignsRequest listCampaignsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListCampaignsIterable(this, this.applyPaginatorUserAgent(listCampaignsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetExportJobsResponse listDatasetExportJobs(ListDatasetExportJobsRequest listDatasetExportJobsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetExportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listDatasetExportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasetExportJobs");
            ListDatasetExportJobsResponse listDatasetExportJobsResponse = (ListDatasetExportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasetExportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetExportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatasetExportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatasetExportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listDatasetExportJobs$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDatasetExportJobsIterable listDatasetExportJobsPaginator(ListDatasetExportJobsRequest listDatasetExportJobsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListDatasetExportJobsIterable(this, this.applyPaginatorUserAgent(listDatasetExportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetGroupsResponse listDatasetGroups(ListDatasetGroupsRequest listDatasetGroupsRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listDatasetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasetGroups");
            ListDatasetGroupsResponse listDatasetGroupsResponse = (ListDatasetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatasetGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatasetGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listDatasetGroups$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDatasetGroupsIterable listDatasetGroupsPaginator(ListDatasetGroupsRequest listDatasetGroupsRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListDatasetGroupsIterable(this, this.applyPaginatorUserAgent(listDatasetGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetImportJobsResponse listDatasetImportJobs(ListDatasetImportJobsRequest listDatasetImportJobsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetImportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listDatasetImportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasetImportJobs");
            ListDatasetImportJobsResponse listDatasetImportJobsResponse = (ListDatasetImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasetImportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetImportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatasetImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatasetImportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listDatasetImportJobs$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDatasetImportJobsIterable listDatasetImportJobsPaginator(ListDatasetImportJobsRequest listDatasetImportJobsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListDatasetImportJobsIterable(this, this.applyPaginatorUserAgent(listDatasetImportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listDatasetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasets");
            ListDatasetsResponse listDatasetsResponse = (ListDatasetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatasetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatasetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listDatasets$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDatasetsIterable listDatasetsPaginator(ListDatasetsRequest listDatasetsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListDatasetsIterable(this, this.applyPaginatorUserAgent(listDatasetsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventTrackersResponse listEventTrackers(ListEventTrackersRequest listEventTrackersRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventTrackersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listEventTrackersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventTrackers");
            ListEventTrackersResponse listEventTrackersResponse = (ListEventTrackersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventTrackers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEventTrackersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEventTrackersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventTrackersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listEventTrackers$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEventTrackersIterable listEventTrackersPaginator(ListEventTrackersRequest listEventTrackersRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListEventTrackersIterable(this, this.applyPaginatorUserAgent(listEventTrackersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFiltersResponse listFilters(ListFiltersRequest listFiltersRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFiltersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listFiltersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFilters");
            ListFiltersResponse listFiltersResponse = (ListFiltersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFilters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFiltersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFiltersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFiltersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listFilters$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListFiltersIterable listFiltersPaginator(ListFiltersRequest listFiltersRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListFiltersIterable(this, this.applyPaginatorUserAgent(listFiltersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMetricAttributionMetricsResponse listMetricAttributionMetrics(ListMetricAttributionMetricsRequest listMetricAttributionMetricsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMetricAttributionMetricsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listMetricAttributionMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMetricAttributionMetrics");
            ListMetricAttributionMetricsResponse listMetricAttributionMetricsResponse = (ListMetricAttributionMetricsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMetricAttributionMetrics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMetricAttributionMetricsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMetricAttributionMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMetricAttributionMetricsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listMetricAttributionMetrics$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMetricAttributionMetricsIterable listMetricAttributionMetricsPaginator(ListMetricAttributionMetricsRequest listMetricAttributionMetricsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListMetricAttributionMetricsIterable(this, this.applyPaginatorUserAgent(listMetricAttributionMetricsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMetricAttributionsResponse listMetricAttributions(ListMetricAttributionsRequest listMetricAttributionsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMetricAttributionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listMetricAttributionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMetricAttributions");
            ListMetricAttributionsResponse listMetricAttributionsResponse = (ListMetricAttributionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMetricAttributions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMetricAttributionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMetricAttributionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMetricAttributionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listMetricAttributions$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMetricAttributionsIterable listMetricAttributionsPaginator(ListMetricAttributionsRequest listMetricAttributionsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListMetricAttributionsIterable(this, this.applyPaginatorUserAgent(listMetricAttributionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecipesResponse listRecipes(ListRecipesRequest listRecipesRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecipesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listRecipesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecipes");
            ListRecipesResponse listRecipesResponse = (ListRecipesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecipes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRecipesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRecipesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRecipesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listRecipes$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRecipesIterable listRecipesPaginator(ListRecipesRequest listRecipesRequest) throws InvalidNextTokenException, InvalidInputException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListRecipesIterable(this, this.applyPaginatorUserAgent(listRecipesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecommendersResponse listRecommenders(ListRecommendersRequest listRecommendersRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecommendersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listRecommendersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecommenders");
            ListRecommendersResponse listRecommendersResponse = (ListRecommendersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecommenders").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRecommendersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRecommendersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRecommendersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listRecommenders$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRecommendersIterable listRecommendersPaginator(ListRecommendersRequest listRecommendersRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListRecommendersIterable(this, this.applyPaginatorUserAgent(listRecommendersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSchemasResponse listSchemas(ListSchemasRequest listSchemasRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSchemasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listSchemasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSchemas");
            ListSchemasResponse listSchemasResponse = (ListSchemasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSchemas").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSchemasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSchemasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSchemasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listSchemas$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSchemasIterable listSchemasPaginator(ListSchemasRequest listSchemasRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListSchemasIterable(this, this.applyPaginatorUserAgent(listSchemasRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSolutionVersionsResponse listSolutionVersions(ListSolutionVersionsRequest listSolutionVersionsRequest) throws InvalidInputException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSolutionVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listSolutionVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSolutionVersions");
            ListSolutionVersionsResponse listSolutionVersionsResponse = (ListSolutionVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSolutionVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSolutionVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSolutionVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSolutionVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listSolutionVersions$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSolutionVersionsIterable listSolutionVersionsPaginator(ListSolutionVersionsRequest listSolutionVersionsRequest) throws InvalidInputException, ResourceNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListSolutionVersionsIterable(this, this.applyPaginatorUserAgent(listSolutionVersionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSolutionsResponse listSolutions(ListSolutionsRequest listSolutionsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSolutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listSolutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSolutions");
            ListSolutionsResponse listSolutionsResponse = (ListSolutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSolutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSolutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSolutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSolutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listSolutions$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSolutionsIterable listSolutionsPaginator(ListSolutionsRequest listSolutionsRequest) throws InvalidInputException, InvalidNextTokenException, AwsServiceException, SdkClientException, PersonalizeException {
        return new ListSolutionsIterable(this, this.applyPaginatorUserAgent(listSolutionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$listTagsForResource$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartRecommenderResponse startRecommender(StartRecommenderRequest startRecommenderRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartRecommenderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, startRecommenderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartRecommender");
            StartRecommenderResponse startRecommenderResponse = (StartRecommenderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartRecommender").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startRecommenderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartRecommenderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startRecommenderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$startRecommender$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopRecommenderResponse stopRecommender(StopRecommenderRequest stopRecommenderRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopRecommenderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, stopRecommenderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopRecommender");
            StopRecommenderResponse stopRecommenderResponse = (StopRecommenderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopRecommender").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopRecommenderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopRecommenderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopRecommenderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$stopRecommender$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopSolutionVersionCreationResponse stopSolutionVersionCreation(StopSolutionVersionCreationRequest stopSolutionVersionCreationRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopSolutionVersionCreationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, stopSolutionVersionCreationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopSolutionVersionCreation");
            StopSolutionVersionCreationResponse stopSolutionVersionCreationResponse = (StopSolutionVersionCreationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopSolutionVersionCreation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopSolutionVersionCreationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopSolutionVersionCreationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopSolutionVersionCreationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$stopSolutionVersionCreation$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidInputException, ResourceNotFoundException, TooManyTagsException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$tagResource$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidInputException, ResourceNotFoundException, TooManyTagKeysException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$untagResource$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCampaignResponse updateCampaign(UpdateCampaignRequest updateCampaignRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, updateCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCampaign");
            UpdateCampaignResponse updateCampaignResponse = (UpdateCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCampaignRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCampaignResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$updateCampaign$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMetricAttributionResponse updateMetricAttribution(UpdateMetricAttributionRequest updateMetricAttributionRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMetricAttributionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, updateMetricAttributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMetricAttribution");
            UpdateMetricAttributionResponse updateMetricAttributionResponse = (UpdateMetricAttributionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMetricAttribution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateMetricAttributionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMetricAttributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMetricAttributionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$updateMetricAttribution$64((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRecommenderResponse updateRecommender(UpdateRecommenderRequest updateRecommenderRequest) throws InvalidInputException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, PersonalizeException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRecommenderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultPersonalizeClient.resolveMetricPublishers(this.clientConfiguration, updateRecommenderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Personalize");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRecommender");
            UpdateRecommenderResponse updateRecommenderResponse = (UpdateRecommenderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRecommender").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRecommenderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRecommenderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRecommenderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultPersonalizeClient.lambda$updateRecommender$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends PersonalizeRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.78").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((PersonalizeRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "personalize";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(PersonalizeException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").exceptionBuilderSupplier(TooManyTagKeysException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final PersonalizeServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateRecommender$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMetricAttribution$64(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCampaign$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopSolutionVersionCreation$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopRecommender$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startRecommender$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSolutions$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSolutionVersions$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSchemas$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecommenders$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecipes$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMetricAttributions$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMetricAttributionMetrics$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFilters$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventTrackers$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasets$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasetImportJobs$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasetGroups$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasetExportJobs$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCampaigns$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBatchSegmentJobs$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBatchInferenceJobs$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSolutionMetrics$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSolutionVersion$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSolution$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSchema$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRecommender$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRecipe$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMetricAttribution$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFilter$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFeatureTransformation$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventTracker$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDatasetImportJob$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDatasetGroup$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDatasetExportJob$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataset$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCampaign$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBatchSegmentJob$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBatchInferenceJob$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAlgorithm$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSolution$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSchema$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRecommender$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMetricAttribution$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFilter$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEventTracker$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDatasetGroup$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataset$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCampaign$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSolutionVersion$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSolution$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSchema$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRecommender$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMetricAttribution$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFilter$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEventTracker$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatasetImportJob$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatasetGroup$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDatasetExportJob$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataset$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCampaign$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBatchSegmentJob$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBatchInferenceJob$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

