/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.DataSource;
import software.amazon.awssdk.services.personalize.model.ImportMode;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.services.personalize.model.Tag;
import software.amazon.awssdk.services.personalize.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDatasetImportJobRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, CreateDatasetImportJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::jobName)).setter(CreateDatasetImportJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetArn").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::datasetArn)).setter(CreateDatasetImportJobRequest.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSource").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::dataSource)).setter(CreateDatasetImportJobRequest.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::roleArn)).setter(CreateDatasetImportJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::tags)).setter(CreateDatasetImportJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMPORT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importMode").getter(CreateDatasetImportJobRequest.getter(CreateDatasetImportJobRequest::importModeAsString)).setter(CreateDatasetImportJobRequest.setter(Builder::importMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, DATASET_ARN_FIELD, DATA_SOURCE_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, IMPORT_MODE_FIELD));
    private final String jobName;
    private final String datasetArn;
    private final DataSource dataSource;
    private final String roleArn;
    private final List<Tag> tags;
    private final String importMode;

    private CreateDatasetImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.datasetArn = builder.datasetArn;
        this.dataSource = builder.dataSource;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.importMode = builder.importMode;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ImportMode importMode() {
        return ImportMode.fromValue(this.importMode);
    }

    public final String importModeAsString() {
        return this.importMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.importModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetImportJobRequest)) {
            return false;
        }
        CreateDatasetImportJobRequest other = (CreateDatasetImportJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.importModeAsString(), other.importModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDatasetImportJobRequest").add("JobName", (Object)this.jobName()).add("DatasetArn", (Object)this.datasetArn()).add("DataSource", (Object)this.dataSource()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("ImportMode", (Object)this.importModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "datasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "importMode": {
                return Optional.ofNullable(clazz.cast(this.importModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetImportJobRequest, T> g) {
        return obj -> g.apply((CreateDatasetImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String datasetArn;
        private DataSource dataSource;
        private String roleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String importMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetImportJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.datasetArn(model.datasetArn);
            this.dataSource(model.dataSource);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.importMode(model.importMode);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImportMode() {
            return this.importMode;
        }

        public final void setImportMode(String importMode) {
            this.importMode = importMode;
        }

        @Override
        public final Builder importMode(String importMode) {
            this.importMode = importMode;
            return this;
        }

        @Override
        public final Builder importMode(ImportMode importMode) {
            this.importMode(importMode == null ? null : importMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetImportJobRequest build() {
            return new CreateDatasetImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDatasetImportJobRequest> {
        public Builder jobName(String var1);

        public Builder datasetArn(String var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder roleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder importMode(String var1);

        public Builder importMode(ImportMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

