/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.model.ListRecipesRequest;
import software.amazon.awssdk.services.personalize.model.ListRecipesResponse;
import software.amazon.awssdk.services.personalize.model.RecipeSummary;

public class ListRecipesIterable
implements SdkIterable<ListRecipesResponse> {
    private final PersonalizeClient client;
    private final ListRecipesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecipesIterable(PersonalizeClient client, ListRecipesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRecipesResponseFetcher();
    }

    public Iterator<ListRecipesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecipeSummary> recipes() {
        Function<ListRecipesResponse, Iterator> getIterator = response -> {
            if (response != null && response.recipes() != null) {
                return response.recipes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecipesResponseFetcher
    implements SyncPageFetcher<ListRecipesResponse> {
        private ListRecipesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecipesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecipesResponse nextPage(ListRecipesResponse previousPage) {
            if (previousPage == null) {
                return ListRecipesIterable.this.client.listRecipes(ListRecipesIterable.this.firstRequest);
            }
            return ListRecipesIterable.this.client.listRecipes((ListRecipesRequest)((Object)ListRecipesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

