/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.DatasetExportJobOutput;
import software.amazon.awssdk.services.personalize.model.IngestionMode;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDatasetExportJobRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, CreateDatasetExportJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(CreateDatasetExportJobRequest.getter(CreateDatasetExportJobRequest::jobName)).setter(CreateDatasetExportJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetArn").getter(CreateDatasetExportJobRequest.getter(CreateDatasetExportJobRequest::datasetArn)).setter(CreateDatasetExportJobRequest.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()}).build();
    private static final SdkField<String> INGESTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestionMode").getter(CreateDatasetExportJobRequest.getter(CreateDatasetExportJobRequest::ingestionModeAsString)).setter(CreateDatasetExportJobRequest.setter(Builder::ingestionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionMode").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateDatasetExportJobRequest.getter(CreateDatasetExportJobRequest::roleArn)).setter(CreateDatasetExportJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<DatasetExportJobOutput> JOB_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobOutput").getter(CreateDatasetExportJobRequest.getter(CreateDatasetExportJobRequest::jobOutput)).setter(CreateDatasetExportJobRequest.setter(Builder::jobOutput)).constructor(DatasetExportJobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, DATASET_ARN_FIELD, INGESTION_MODE_FIELD, ROLE_ARN_FIELD, JOB_OUTPUT_FIELD));
    private final String jobName;
    private final String datasetArn;
    private final String ingestionMode;
    private final String roleArn;
    private final DatasetExportJobOutput jobOutput;

    private CreateDatasetExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.datasetArn = builder.datasetArn;
        this.ingestionMode = builder.ingestionMode;
        this.roleArn = builder.roleArn;
        this.jobOutput = builder.jobOutput;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final IngestionMode ingestionMode() {
        return IngestionMode.fromValue(this.ingestionMode);
    }

    public final String ingestionModeAsString() {
        return this.ingestionMode;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final DatasetExportJobOutput jobOutput() {
        return this.jobOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOutput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetExportJobRequest)) {
            return false;
        }
        CreateDatasetExportJobRequest other = (CreateDatasetExportJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.ingestionModeAsString(), other.ingestionModeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.jobOutput(), other.jobOutput());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDatasetExportJobRequest").add("JobName", (Object)this.jobName()).add("DatasetArn", (Object)this.datasetArn()).add("IngestionMode", (Object)this.ingestionModeAsString()).add("RoleArn", (Object)this.roleArn()).add("JobOutput", (Object)this.jobOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "datasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "ingestionMode": {
                return Optional.ofNullable(clazz.cast(this.ingestionModeAsString()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "jobOutput": {
                return Optional.ofNullable(clazz.cast(this.jobOutput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetExportJobRequest, T> g) {
        return obj -> g.apply((CreateDatasetExportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String datasetArn;
        private String ingestionMode;
        private String roleArn;
        private DatasetExportJobOutput jobOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetExportJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.datasetArn(model.datasetArn);
            this.ingestionMode(model.ingestionMode);
            this.roleArn(model.roleArn);
            this.jobOutput(model.jobOutput);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        @Transient
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getIngestionMode() {
            return this.ingestionMode;
        }

        public final void setIngestionMode(String ingestionMode) {
            this.ingestionMode = ingestionMode;
        }

        @Override
        @Transient
        public final Builder ingestionMode(String ingestionMode) {
            this.ingestionMode = ingestionMode;
            return this;
        }

        @Override
        @Transient
        public final Builder ingestionMode(IngestionMode ingestionMode) {
            this.ingestionMode(ingestionMode == null ? null : ingestionMode.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DatasetExportJobOutput.Builder getJobOutput() {
            return this.jobOutput != null ? this.jobOutput.toBuilder() : null;
        }

        public final void setJobOutput(DatasetExportJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        @Override
        @Transient
        public final Builder jobOutput(DatasetExportJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetExportJobRequest build() {
            return new CreateDatasetExportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDatasetExportJobRequest> {
        public Builder jobName(String var1);

        public Builder datasetArn(String var1);

        public Builder ingestionMode(String var1);

        public Builder ingestionMode(IngestionMode var1);

        public Builder roleArn(String var1);

        public Builder jobOutput(DatasetExportJobOutput var1);

        default public Builder jobOutput(Consumer<DatasetExportJobOutput.Builder> jobOutput) {
            return this.jobOutput((DatasetExportJobOutput)((DatasetExportJobOutput.Builder)DatasetExportJobOutput.builder().applyMutation(jobOutput)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

