/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.FeaturizationParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FeatureTransformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FeatureTransformation> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(FeatureTransformation.getter(FeatureTransformation::name)).setter(FeatureTransformation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> FEATURE_TRANSFORMATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("featureTransformationArn").getter(FeatureTransformation.getter(FeatureTransformation::featureTransformationArn)).setter(FeatureTransformation.setter(Builder::featureTransformationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureTransformationArn").build()}).build();
    private static final SdkField<Map<String, String>> DEFAULT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("defaultParameters").getter(FeatureTransformation.getter(FeatureTransformation::defaultParameters)).setter(FeatureTransformation.setter(Builder::defaultParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(FeatureTransformation.getter(FeatureTransformation::creationDateTime)).setter(FeatureTransformation.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(FeatureTransformation.getter(FeatureTransformation::lastUpdatedDateTime)).setter(FeatureTransformation.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(FeatureTransformation.getter(FeatureTransformation::status)).setter(FeatureTransformation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FEATURE_TRANSFORMATION_ARN_FIELD, DEFAULT_PARAMETERS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String featureTransformationArn;
    private final Map<String, String> defaultParameters;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final String status;

    private FeatureTransformation(BuilderImpl builder) {
        this.name = builder.name;
        this.featureTransformationArn = builder.featureTransformationArn;
        this.defaultParameters = builder.defaultParameters;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.status = builder.status;
    }

    public final String name() {
        return this.name;
    }

    public final String featureTransformationArn() {
        return this.featureTransformationArn;
    }

    public final boolean hasDefaultParameters() {
        return this.defaultParameters != null && !(this.defaultParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> defaultParameters() {
        return this.defaultParameters;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureTransformationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultParameters() ? this.defaultParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureTransformation)) {
            return false;
        }
        FeatureTransformation other = (FeatureTransformation)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.featureTransformationArn(), other.featureTransformationArn()) && this.hasDefaultParameters() == other.hasDefaultParameters() && Objects.equals(this.defaultParameters(), other.defaultParameters()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"FeatureTransformation").add("Name", (Object)this.name()).add("FeatureTransformationArn", (Object)this.featureTransformationArn()).add("DefaultParameters", this.hasDefaultParameters() ? this.defaultParameters() : null).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "featureTransformationArn": {
                return Optional.ofNullable(clazz.cast(this.featureTransformationArn()));
            }
            case "defaultParameters": {
                return Optional.ofNullable(clazz.cast(this.defaultParameters()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FeatureTransformation, T> g) {
        return obj -> g.apply((FeatureTransformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String featureTransformationArn;
        private Map<String, String> defaultParameters = DefaultSdkAutoConstructMap.getInstance();
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(FeatureTransformation model) {
            this.name(model.name);
            this.featureTransformationArn(model.featureTransformationArn);
            this.defaultParameters(model.defaultParameters);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.status(model.status);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFeatureTransformationArn() {
            return this.featureTransformationArn;
        }

        @Override
        public final Builder featureTransformationArn(String featureTransformationArn) {
            this.featureTransformationArn = featureTransformationArn;
            return this;
        }

        public final void setFeatureTransformationArn(String featureTransformationArn) {
            this.featureTransformationArn = featureTransformationArn;
        }

        public final Map<String, String> getDefaultParameters() {
            if (this.defaultParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.defaultParameters;
        }

        @Override
        public final Builder defaultParameters(Map<String, String> defaultParameters) {
            this.defaultParameters = FeaturizationParametersCopier.copy(defaultParameters);
            return this;
        }

        public final void setDefaultParameters(Map<String, String> defaultParameters) {
            this.defaultParameters = FeaturizationParametersCopier.copy(defaultParameters);
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public FeatureTransformation build() {
            return new FeatureTransformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FeatureTransformation> {
        public Builder name(String var1);

        public Builder featureTransformationArn(String var1);

        public Builder defaultParameters(Map<String, String> var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder status(String var1);
    }
}

