/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.BatchInferenceJobConfig;
import software.amazon.awssdk.services.personalize.model.BatchInferenceJobInput;
import software.amazon.awssdk.services.personalize.model.BatchInferenceJobOutput;
import software.amazon.awssdk.services.personalize.model.PersonalizeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBatchInferenceJobRequest
extends PersonalizeRequest
implements ToCopyableBuilder<Builder, CreateBatchInferenceJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(CreateBatchInferenceJobRequest.getter(CreateBatchInferenceJobRequest::jobName)).setter(CreateBatchInferenceJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> SOLUTION_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("solutionVersionArn").getter(CreateBatchInferenceJobRequest.getter(CreateBatchInferenceJobRequest::solutionVersionArn)).setter(CreateBatchInferenceJobRequest.setter(Builder::solutionVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionVersionArn").build()}).build();
    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterArn").getter(CreateBatchInferenceJobRequest.getter(CreateBatchInferenceJobRequest::filterArn)).setter(CreateBatchInferenceJobRequest.setter(Builder::filterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()}).build();
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numResults").getter(CreateBatchInferenceJobRequest.getter(CreateBatchInferenceJobRequest::numResults)).setter(CreateBatchInferenceJobRequest.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()}).build();
    private static final SdkField<BatchInferenceJobInput> JOB_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobInput").getter(CreateBatchInferenceJobRequest.getter(CreateBatchInferenceJobRequest::jobInput)).setter(CreateBatchInferenceJobRequest.setter(Builder::jobInput)).constructor(BatchInferenceJobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInput").build()}).build();
    private static final SdkField<BatchInferenceJobOutput> JOB_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobOutput").getter(CreateBatchInferenceJobRequest.getter(CreateBatchInferenceJobRequest::jobOutput)).setter(CreateBatchInferenceJobRequest.setter(Builder::jobOutput)).constructor(BatchInferenceJobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOutput").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateBatchInferenceJobRequest.getter(CreateBatchInferenceJobRequest::roleArn)).setter(CreateBatchInferenceJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<BatchInferenceJobConfig> BATCH_INFERENCE_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("batchInferenceJobConfig").getter(CreateBatchInferenceJobRequest.getter(CreateBatchInferenceJobRequest::batchInferenceJobConfig)).setter(CreateBatchInferenceJobRequest.setter(Builder::batchInferenceJobConfig)).constructor(BatchInferenceJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJobConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, SOLUTION_VERSION_ARN_FIELD, FILTER_ARN_FIELD, NUM_RESULTS_FIELD, JOB_INPUT_FIELD, JOB_OUTPUT_FIELD, ROLE_ARN_FIELD, BATCH_INFERENCE_JOB_CONFIG_FIELD));
    private final String jobName;
    private final String solutionVersionArn;
    private final String filterArn;
    private final Integer numResults;
    private final BatchInferenceJobInput jobInput;
    private final BatchInferenceJobOutput jobOutput;
    private final String roleArn;
    private final BatchInferenceJobConfig batchInferenceJobConfig;

    private CreateBatchInferenceJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.solutionVersionArn = builder.solutionVersionArn;
        this.filterArn = builder.filterArn;
        this.numResults = builder.numResults;
        this.jobInput = builder.jobInput;
        this.jobOutput = builder.jobOutput;
        this.roleArn = builder.roleArn;
        this.batchInferenceJobConfig = builder.batchInferenceJobConfig;
    }

    public String jobName() {
        return this.jobName;
    }

    public String solutionVersionArn() {
        return this.solutionVersionArn;
    }

    public String filterArn() {
        return this.filterArn;
    }

    public Integer numResults() {
        return this.numResults;
    }

    public BatchInferenceJobInput jobInput() {
        return this.jobInput;
    }

    public BatchInferenceJobOutput jobOutput() {
        return this.jobOutput;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public BatchInferenceJobConfig batchInferenceJobConfig() {
        return this.batchInferenceJobConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchInferenceJobConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBatchInferenceJobRequest)) {
            return false;
        }
        CreateBatchInferenceJobRequest other = (CreateBatchInferenceJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.solutionVersionArn(), other.solutionVersionArn()) && Objects.equals(this.filterArn(), other.filterArn()) && Objects.equals(this.numResults(), other.numResults()) && Objects.equals(this.jobInput(), other.jobInput()) && Objects.equals(this.jobOutput(), other.jobOutput()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.batchInferenceJobConfig(), other.batchInferenceJobConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreateBatchInferenceJobRequest").add("JobName", (Object)this.jobName()).add("SolutionVersionArn", (Object)this.solutionVersionArn()).add("FilterArn", (Object)this.filterArn()).add("NumResults", (Object)this.numResults()).add("JobInput", (Object)this.jobInput()).add("JobOutput", (Object)this.jobOutput()).add("RoleArn", (Object)this.roleArn()).add("BatchInferenceJobConfig", (Object)this.batchInferenceJobConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "solutionVersionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionVersionArn()));
            }
            case "filterArn": {
                return Optional.ofNullable(clazz.cast(this.filterArn()));
            }
            case "numResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "jobInput": {
                return Optional.ofNullable(clazz.cast(this.jobInput()));
            }
            case "jobOutput": {
                return Optional.ofNullable(clazz.cast(this.jobOutput()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "batchInferenceJobConfig": {
                return Optional.ofNullable(clazz.cast(this.batchInferenceJobConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBatchInferenceJobRequest, T> g) {
        return obj -> g.apply((CreateBatchInferenceJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String solutionVersionArn;
        private String filterArn;
        private Integer numResults;
        private BatchInferenceJobInput jobInput;
        private BatchInferenceJobOutput jobOutput;
        private String roleArn;
        private BatchInferenceJobConfig batchInferenceJobConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBatchInferenceJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.solutionVersionArn(model.solutionVersionArn);
            this.filterArn(model.filterArn);
            this.numResults(model.numResults);
            this.jobInput(model.jobInput);
            this.jobOutput(model.jobOutput);
            this.roleArn(model.roleArn);
            this.batchInferenceJobConfig(model.batchInferenceJobConfig);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getSolutionVersionArn() {
            return this.solutionVersionArn;
        }

        @Override
        public final Builder solutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
            return this;
        }

        public final void setSolutionVersionArn(String solutionVersionArn) {
            this.solutionVersionArn = solutionVersionArn;
        }

        public final String getFilterArn() {
            return this.filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        public final BatchInferenceJobInput.Builder getJobInput() {
            return this.jobInput != null ? this.jobInput.toBuilder() : null;
        }

        @Override
        public final Builder jobInput(BatchInferenceJobInput jobInput) {
            this.jobInput = jobInput;
            return this;
        }

        public final void setJobInput(BatchInferenceJobInput.BuilderImpl jobInput) {
            this.jobInput = jobInput != null ? jobInput.build() : null;
        }

        public final BatchInferenceJobOutput.Builder getJobOutput() {
            return this.jobOutput != null ? this.jobOutput.toBuilder() : null;
        }

        @Override
        public final Builder jobOutput(BatchInferenceJobOutput jobOutput) {
            this.jobOutput = jobOutput;
            return this;
        }

        public final void setJobOutput(BatchInferenceJobOutput.BuilderImpl jobOutput) {
            this.jobOutput = jobOutput != null ? jobOutput.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final BatchInferenceJobConfig.Builder getBatchInferenceJobConfig() {
            return this.batchInferenceJobConfig != null ? this.batchInferenceJobConfig.toBuilder() : null;
        }

        @Override
        public final Builder batchInferenceJobConfig(BatchInferenceJobConfig batchInferenceJobConfig) {
            this.batchInferenceJobConfig = batchInferenceJobConfig;
            return this;
        }

        public final void setBatchInferenceJobConfig(BatchInferenceJobConfig.BuilderImpl batchInferenceJobConfig) {
            this.batchInferenceJobConfig = batchInferenceJobConfig != null ? batchInferenceJobConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBatchInferenceJobRequest build() {
            return new CreateBatchInferenceJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBatchInferenceJobRequest> {
        public Builder jobName(String var1);

        public Builder solutionVersionArn(String var1);

        public Builder filterArn(String var1);

        public Builder numResults(Integer var1);

        public Builder jobInput(BatchInferenceJobInput var1);

        default public Builder jobInput(Consumer<BatchInferenceJobInput.Builder> jobInput) {
            return this.jobInput((BatchInferenceJobInput)((BatchInferenceJobInput.Builder)BatchInferenceJobInput.builder().applyMutation(jobInput)).build());
        }

        public Builder jobOutput(BatchInferenceJobOutput var1);

        default public Builder jobOutput(Consumer<BatchInferenceJobOutput.Builder> jobOutput) {
            return this.jobOutput((BatchInferenceJobOutput)((BatchInferenceJobOutput.Builder)BatchInferenceJobOutput.builder().applyMutation(jobOutput)).build());
        }

        public Builder roleArn(String var1);

        public Builder batchInferenceJobConfig(BatchInferenceJobConfig var1);

        default public Builder batchInferenceJobConfig(Consumer<BatchInferenceJobConfig.Builder> batchInferenceJobConfig) {
            return this.batchInferenceJobConfig((BatchInferenceJobConfig)((BatchInferenceJobConfig.Builder)BatchInferenceJobConfig.builder().applyMutation(batchInferenceJobConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

