/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RecipeProvider {
    SERVICE("SERVICE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RecipeProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecipeProvider fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RecipeProvider.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecipeProvider> knownValues() {
        return Stream.of(RecipeProvider.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

