/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.services.personalize.model.SolutionSummary;
import software.amazon.awssdk.services.personalize.model.SolutionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSolutionsResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListSolutionsResponse> {
    private static final SdkField<List<SolutionSummary>> SOLUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListSolutionsResponse.getter(ListSolutionsResponse::solutions)).setter(ListSolutionsResponse.setter(Builder::solutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SolutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListSolutionsResponse.getter(ListSolutionsResponse::nextToken)).setter(ListSolutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<SolutionSummary> solutions;
    private final String nextToken;

    private ListSolutionsResponse(BuilderImpl builder) {
        super(builder);
        this.solutions = builder.solutions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSolutions() {
        return this.solutions != null && !(this.solutions instanceof SdkAutoConstructList);
    }

    public List<SolutionSummary> solutions() {
        return this.solutions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.solutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolutionsResponse)) {
            return false;
        }
        ListSolutionsResponse other = (ListSolutionsResponse)((Object)obj);
        return Objects.equals(this.solutions(), other.solutions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSolutionsResponse").add("Solutions", this.solutions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "solutions": {
                return Optional.ofNullable(clazz.cast(this.solutions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSolutionsResponse, T> g) {
        return obj -> g.apply((ListSolutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<SolutionSummary> solutions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolutionsResponse model) {
            super(model);
            this.solutions(model.solutions);
            this.nextToken(model.nextToken);
        }

        public final Collection<SolutionSummary.Builder> getSolutions() {
            return this.solutions != null ? (Collection)this.solutions.stream().map(SolutionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder solutions(Collection<SolutionSummary> solutions) {
            this.solutions = SolutionsCopier.copy(solutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutions(SolutionSummary ... solutions) {
            this.solutions(Arrays.asList(solutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutions(Consumer<SolutionSummary.Builder> ... solutions) {
            this.solutions(Stream.of(solutions).map(c -> (SolutionSummary)((SolutionSummary.Builder)SolutionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSolutions(Collection<SolutionSummary.BuilderImpl> solutions) {
            this.solutions = SolutionsCopier.copyFromBuilder(solutions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSolutionsResponse build() {
            return new ListSolutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSolutionsResponse> {
        public Builder solutions(Collection<SolutionSummary> var1);

        public Builder solutions(SolutionSummary ... var1);

        public Builder solutions(Consumer<SolutionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

