/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDatasetImportJobsResponse extends PersonalizeResponse implements
        ToCopyableBuilder<ListDatasetImportJobsResponse.Builder, ListDatasetImportJobsResponse> {
    private static final SdkField<List<DatasetImportJobSummary>> DATASET_IMPORT_JOBS_FIELD = SdkField
            .<List<DatasetImportJobSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListDatasetImportJobsResponse::datasetImportJobs))
            .setter(setter(Builder::datasetImportJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetImportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetImportJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetImportJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDatasetImportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DatasetImportJobSummary> datasetImportJobs;

    private final String nextToken;

    private ListDatasetImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.datasetImportJobs = builder.datasetImportJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DatasetImportJobs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDatasetImportJobs() {
        return datasetImportJobs != null && !(datasetImportJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of dataset import jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDatasetImportJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of dataset import jobs.
     */
    public List<DatasetImportJobSummary> datasetImportJobs() {
        return datasetImportJobs;
    }

    /**
     * <p>
     * A token for getting the next set of dataset import jobs (if they exist).
     * </p>
     * 
     * @return A token for getting the next set of dataset import jobs (if they exist).
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetImportJobs());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetImportJobsResponse)) {
            return false;
        }
        ListDatasetImportJobsResponse other = (ListDatasetImportJobsResponse) obj;
        return Objects.equals(datasetImportJobs(), other.datasetImportJobs()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDatasetImportJobsResponse").add("DatasetImportJobs", datasetImportJobs())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetImportJobs":
            return Optional.ofNullable(clazz.cast(datasetImportJobs()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetImportJobsResponse, T> g) {
        return obj -> g.apply((ListDatasetImportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDatasetImportJobsResponse> {
        /**
         * <p>
         * The list of dataset import jobs.
         * </p>
         * 
         * @param datasetImportJobs
         *        The list of dataset import jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobs(Collection<DatasetImportJobSummary> datasetImportJobs);

        /**
         * <p>
         * The list of dataset import jobs.
         * </p>
         * 
         * @param datasetImportJobs
         *        The list of dataset import jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobs(DatasetImportJobSummary... datasetImportJobs);

        /**
         * <p>
         * The list of dataset import jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatasetImportJobSummary>.Builder} avoiding
         * the need to create one manually via {@link List<DatasetImportJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetImportJobSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #datasetImportJobs(List<DatasetImportJobSummary>)}.
         * 
         * @param datasetImportJobs
         *        a consumer that will call methods on {@link List<DatasetImportJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetImportJobs(List<DatasetImportJobSummary>)
         */
        Builder datasetImportJobs(Consumer<DatasetImportJobSummary.Builder>... datasetImportJobs);

        /**
         * <p>
         * A token for getting the next set of dataset import jobs (if they exist).
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of dataset import jobs (if they exist).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PersonalizeResponse.BuilderImpl implements Builder {
        private List<DatasetImportJobSummary> datasetImportJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetImportJobsResponse model) {
            super(model);
            datasetImportJobs(model.datasetImportJobs);
            nextToken(model.nextToken);
        }

        public final Collection<DatasetImportJobSummary.Builder> getDatasetImportJobs() {
            return datasetImportJobs != null ? datasetImportJobs.stream().map(DatasetImportJobSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder datasetImportJobs(Collection<DatasetImportJobSummary> datasetImportJobs) {
            this.datasetImportJobs = DatasetImportJobsCopier.copy(datasetImportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetImportJobs(DatasetImportJobSummary... datasetImportJobs) {
            datasetImportJobs(Arrays.asList(datasetImportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetImportJobs(Consumer<DatasetImportJobSummary.Builder>... datasetImportJobs) {
            datasetImportJobs(Stream.of(datasetImportJobs).map(c -> DatasetImportJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDatasetImportJobs(Collection<DatasetImportJobSummary.BuilderImpl> datasetImportJobs) {
            this.datasetImportJobs = DatasetImportJobsCopier.copyFromBuilder(datasetImportJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDatasetImportJobsResponse build() {
            return new ListDatasetImportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
