/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output configuration parameters of a batch inference job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchInferenceJobOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchInferenceJobOutput.Builder, BatchInferenceJobOutput> {
    private static final SdkField<S3DataConfig> S3_DATA_DESTINATION_FIELD = SdkField
            .<S3DataConfig> builder(MarshallingType.SDK_POJO).getter(getter(BatchInferenceJobOutput::s3DataDestination))
            .setter(setter(Builder::s3DataDestination)).constructor(S3DataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DataDestination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3DataConfig s3DataDestination;

    private BatchInferenceJobOutput(BuilderImpl builder) {
        this.s3DataDestination = builder.s3DataDestination;
    }

    /**
     * <p>
     * Information on the Amazon S3 bucket in which the batch inference job's output is stored.
     * </p>
     * 
     * @return Information on the Amazon S3 bucket in which the batch inference job's output is stored.
     */
    public S3DataConfig s3DataDestination() {
        return s3DataDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3DataDestination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchInferenceJobOutput)) {
            return false;
        }
        BatchInferenceJobOutput other = (BatchInferenceJobOutput) obj;
        return Objects.equals(s3DataDestination(), other.s3DataDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchInferenceJobOutput").add("S3DataDestination", s3DataDestination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3DataDestination":
            return Optional.ofNullable(clazz.cast(s3DataDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchInferenceJobOutput, T> g) {
        return obj -> g.apply((BatchInferenceJobOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchInferenceJobOutput> {
        /**
         * <p>
         * Information on the Amazon S3 bucket in which the batch inference job's output is stored.
         * </p>
         * 
         * @param s3DataDestination
         *        Information on the Amazon S3 bucket in which the batch inference job's output is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataDestination(S3DataConfig s3DataDestination);

        /**
         * <p>
         * Information on the Amazon S3 bucket in which the batch inference job's output is stored.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DataConfig.Builder} avoiding the need to
         * create one manually via {@link S3DataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3DataDestination(S3DataConfig)}.
         * 
         * @param s3DataDestination
         *        a consumer that will call methods on {@link S3DataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DataDestination(S3DataConfig)
         */
        default Builder s3DataDestination(Consumer<S3DataConfig.Builder> s3DataDestination) {
            return s3DataDestination(S3DataConfig.builder().applyMutation(s3DataDestination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3DataConfig s3DataDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchInferenceJobOutput model) {
            s3DataDestination(model.s3DataDestination);
        }

        public final S3DataConfig.Builder getS3DataDestination() {
            return s3DataDestination != null ? s3DataDestination.toBuilder() : null;
        }

        @Override
        public final Builder s3DataDestination(S3DataConfig s3DataDestination) {
            this.s3DataDestination = s3DataDestination;
            return this;
        }

        public final void setS3DataDestination(S3DataConfig.BuilderImpl s3DataDestination) {
            this.s3DataDestination = s3DataDestination != null ? s3DataDestination.build() : null;
        }

        @Override
        public BatchInferenceJobOutput build() {
            return new BatchInferenceJobOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
