/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSolutionVersionRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateSolutionVersionRequest.Builder, CreateSolutionVersionRequest> {
    private static final SdkField<String> SOLUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSolutionVersionRequest::solutionArn)).setter(setter(Builder::solutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionArn").build()).build();

    private static final SdkField<String> TRAINING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSolutionVersionRequest::trainingModeAsString)).setter(setter(Builder::trainingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_ARN_FIELD,
            TRAINING_MODE_FIELD));

    private final String solutionArn;

    private final String trainingMode;

    private CreateSolutionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.solutionArn = builder.solutionArn;
        this.trainingMode = builder.trainingMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution containing the training configuration information.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution containing the training configuration information.
     */
    public String solutionArn() {
        return solutionArn;
    }

    /**
     * <p>
     * The scope of training to be performed when creating the solution version. The <code>FULL</code> option trains the
     * solution version based on the entirety of the input solution's training data, while the <code>UPDATE</code>
     * option processes only the data that has changed in comparison to the input solution. Choose <code>UPDATE</code>
     * when you want to incrementally update your solution version instead of creating an entirely new one.
     * </p>
     * <important>
     * <p>
     * The <code>UPDATE</code> option can only be used when you already have an active solution version created from the
     * input solution using the <code>FULL</code> option and the input solution was trained with the
     * <a>native-recipe-hrnn-coldstart</a> recipe.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingMode} will
     * return {@link TrainingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trainingModeAsString}.
     * </p>
     * 
     * @return The scope of training to be performed when creating the solution version. The <code>FULL</code> option
     *         trains the solution version based on the entirety of the input solution's training data, while the
     *         <code>UPDATE</code> option processes only the data that has changed in comparison to the input solution.
     *         Choose <code>UPDATE</code> when you want to incrementally update your solution version instead of
     *         creating an entirely new one.</p> <important>
     *         <p>
     *         The <code>UPDATE</code> option can only be used when you already have an active solution version created
     *         from the input solution using the <code>FULL</code> option and the input solution was trained with the
     *         <a>native-recipe-hrnn-coldstart</a> recipe.
     *         </p>
     * @see TrainingMode
     */
    public TrainingMode trainingMode() {
        return TrainingMode.fromValue(trainingMode);
    }

    /**
     * <p>
     * The scope of training to be performed when creating the solution version. The <code>FULL</code> option trains the
     * solution version based on the entirety of the input solution's training data, while the <code>UPDATE</code>
     * option processes only the data that has changed in comparison to the input solution. Choose <code>UPDATE</code>
     * when you want to incrementally update your solution version instead of creating an entirely new one.
     * </p>
     * <important>
     * <p>
     * The <code>UPDATE</code> option can only be used when you already have an active solution version created from the
     * input solution using the <code>FULL</code> option and the input solution was trained with the
     * <a>native-recipe-hrnn-coldstart</a> recipe.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingMode} will
     * return {@link TrainingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trainingModeAsString}.
     * </p>
     * 
     * @return The scope of training to be performed when creating the solution version. The <code>FULL</code> option
     *         trains the solution version based on the entirety of the input solution's training data, while the
     *         <code>UPDATE</code> option processes only the data that has changed in comparison to the input solution.
     *         Choose <code>UPDATE</code> when you want to incrementally update your solution version instead of
     *         creating an entirely new one.</p> <important>
     *         <p>
     *         The <code>UPDATE</code> option can only be used when you already have an active solution version created
     *         from the input solution using the <code>FULL</code> option and the input solution was trained with the
     *         <a>native-recipe-hrnn-coldstart</a> recipe.
     *         </p>
     * @see TrainingMode
     */
    public String trainingModeAsString() {
        return trainingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(solutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(trainingModeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSolutionVersionRequest)) {
            return false;
        }
        CreateSolutionVersionRequest other = (CreateSolutionVersionRequest) obj;
        return Objects.equals(solutionArn(), other.solutionArn())
                && Objects.equals(trainingModeAsString(), other.trainingModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSolutionVersionRequest").add("SolutionArn", solutionArn())
                .add("TrainingMode", trainingModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "solutionArn":
            return Optional.ofNullable(clazz.cast(solutionArn()));
        case "trainingMode":
            return Optional.ofNullable(clazz.cast(trainingModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSolutionVersionRequest, T> g) {
        return obj -> g.apply((CreateSolutionVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSolutionVersionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the solution containing the training configuration information.
         * </p>
         * 
         * @param solutionArn
         *        The Amazon Resource Name (ARN) of the solution containing the training configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionArn(String solutionArn);

        /**
         * <p>
         * The scope of training to be performed when creating the solution version. The <code>FULL</code> option trains
         * the solution version based on the entirety of the input solution's training data, while the
         * <code>UPDATE</code> option processes only the data that has changed in comparison to the input solution.
         * Choose <code>UPDATE</code> when you want to incrementally update your solution version instead of creating an
         * entirely new one.
         * </p>
         * <important>
         * <p>
         * The <code>UPDATE</code> option can only be used when you already have an active solution version created from
         * the input solution using the <code>FULL</code> option and the input solution was trained with the
         * <a>native-recipe-hrnn-coldstart</a> recipe.
         * </p>
         * </important>
         * 
         * @param trainingMode
         *        The scope of training to be performed when creating the solution version. The <code>FULL</code> option
         *        trains the solution version based on the entirety of the input solution's training data, while the
         *        <code>UPDATE</code> option processes only the data that has changed in comparison to the input
         *        solution. Choose <code>UPDATE</code> when you want to incrementally update your solution version
         *        instead of creating an entirely new one.</p> <important>
         *        <p>
         *        The <code>UPDATE</code> option can only be used when you already have an active solution version
         *        created from the input solution using the <code>FULL</code> option and the input solution was trained
         *        with the <a>native-recipe-hrnn-coldstart</a> recipe.
         *        </p>
         * @see TrainingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingMode
         */
        Builder trainingMode(String trainingMode);

        /**
         * <p>
         * The scope of training to be performed when creating the solution version. The <code>FULL</code> option trains
         * the solution version based on the entirety of the input solution's training data, while the
         * <code>UPDATE</code> option processes only the data that has changed in comparison to the input solution.
         * Choose <code>UPDATE</code> when you want to incrementally update your solution version instead of creating an
         * entirely new one.
         * </p>
         * <important>
         * <p>
         * The <code>UPDATE</code> option can only be used when you already have an active solution version created from
         * the input solution using the <code>FULL</code> option and the input solution was trained with the
         * <a>native-recipe-hrnn-coldstart</a> recipe.
         * </p>
         * </important>
         * 
         * @param trainingMode
         *        The scope of training to be performed when creating the solution version. The <code>FULL</code> option
         *        trains the solution version based on the entirety of the input solution's training data, while the
         *        <code>UPDATE</code> option processes only the data that has changed in comparison to the input
         *        solution. Choose <code>UPDATE</code> when you want to incrementally update your solution version
         *        instead of creating an entirely new one.</p> <important>
         *        <p>
         *        The <code>UPDATE</code> option can only be used when you already have an active solution version
         *        created from the input solution using the <code>FULL</code> option and the input solution was trained
         *        with the <a>native-recipe-hrnn-coldstart</a> recipe.
         *        </p>
         * @see TrainingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingMode
         */
        Builder trainingMode(TrainingMode trainingMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String solutionArn;

        private String trainingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSolutionVersionRequest model) {
            super(model);
            solutionArn(model.solutionArn);
            trainingMode(model.trainingMode);
        }

        public final String getSolutionArn() {
            return solutionArn;
        }

        @Override
        public final Builder solutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
            return this;
        }

        public final void setSolutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
        }

        public final String getTrainingModeAsString() {
            return trainingMode;
        }

        @Override
        public final Builder trainingMode(String trainingMode) {
            this.trainingMode = trainingMode;
            return this;
        }

        @Override
        public final Builder trainingMode(TrainingMode trainingMode) {
            this.trainingMode(trainingMode == null ? null : trainingMode.toString());
            return this;
        }

        public final void setTrainingMode(String trainingMode) {
            this.trainingMode = trainingMode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSolutionVersionRequest build() {
            return new CreateSolutionVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
