/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetImportJobRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateDatasetImportJobRequest.Builder, CreateDatasetImportJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDatasetImportJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDatasetImportJobRequest::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateDatasetImportJobRequest::dataSource)).setter(setter(Builder::dataSource))
            .constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDatasetImportJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            DATASET_ARN_FIELD, DATA_SOURCE_FIELD, ROLE_ARN_FIELD));

    private final String jobName;

    private final String datasetArn;

    private final DataSource dataSource;

    private final String roleArn;

    private CreateDatasetImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.datasetArn = builder.datasetArn;
        this.dataSource = builder.dataSource;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name for the dataset import job.
     * </p>
     * 
     * @return The name for the dataset import job.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The ARN of the dataset that receives the imported data.
     * </p>
     * 
     * @return The ARN of the dataset that receives the imported data.
     */
    public String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The Amazon S3 bucket that contains the training data to import.
     * </p>
     * 
     * @return The Amazon S3 bucket that contains the training data to import.
     */
    public DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The ARN of the IAM role that has permissions to read from the Amazon S3 data source.
     * </p>
     * 
     * @return The ARN of the IAM role that has permissions to read from the Amazon S3 data source.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetImportJobRequest)) {
            return false;
        }
        CreateDatasetImportJobRequest other = (CreateDatasetImportJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(dataSource(), other.dataSource()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDatasetImportJobRequest").add("JobName", jobName()).add("DatasetArn", datasetArn())
                .add("DataSource", dataSource()).add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "datasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetImportJobRequest, T> g) {
        return obj -> g.apply((CreateDatasetImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetImportJobRequest> {
        /**
         * <p>
         * The name for the dataset import job.
         * </p>
         * 
         * @param jobName
         *        The name for the dataset import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The ARN of the dataset that receives the imported data.
         * </p>
         * 
         * @param datasetArn
         *        The ARN of the dataset that receives the imported data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The Amazon S3 bucket that contains the training data to import.
         * </p>
         * 
         * @param dataSource
         *        The Amazon S3 bucket that contains the training data to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The Amazon S3 bucket that contains the training data to import.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSource.Builder} avoiding the need to create
         * one manually via {@link DataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The ARN of the IAM role that has permissions to read from the Amazon S3 data source.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that has permissions to read from the Amazon S3 data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String jobName;

        private String datasetArn;

        private DataSource dataSource;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetImportJobRequest model) {
            super(model);
            jobName(model.jobName);
            datasetArn(model.datasetArn);
            dataSource(model.dataSource);
            roleArn(model.roleArn);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetImportJobRequest build() {
            return new CreateDatasetImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
