/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pcs.model.Endpoint;
import software.amazon.awssdk.services.pcs.model.EndpointsCopier;
import software.amazon.awssdk.services.pcs.model.PcsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterComputeNodeGroupInstanceResponse
extends PcsResponse
implements ToCopyableBuilder<Builder, RegisterComputeNodeGroupInstanceResponse> {
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeID").getter(RegisterComputeNodeGroupInstanceResponse.getter(RegisterComputeNodeGroupInstanceResponse::nodeID)).setter(RegisterComputeNodeGroupInstanceResponse.setter(Builder::nodeID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeID").build()}).build();
    private static final SdkField<String> SHARED_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sharedSecret").getter(RegisterComputeNodeGroupInstanceResponse.getter(RegisterComputeNodeGroupInstanceResponse::sharedSecret)).setter(RegisterComputeNodeGroupInstanceResponse.setter(Builder::sharedSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedSecret").build()}).build();
    private static final SdkField<List<Endpoint>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("endpoints").getter(RegisterComputeNodeGroupInstanceResponse.getter(RegisterComputeNodeGroupInstanceResponse::endpoints)).setter(RegisterComputeNodeGroupInstanceResponse.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ID_FIELD, SHARED_SECRET_FIELD, ENDPOINTS_FIELD));
    private final String nodeID;
    private final String sharedSecret;
    private final List<Endpoint> endpoints;

    private RegisterComputeNodeGroupInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.nodeID = builder.nodeID;
        this.sharedSecret = builder.sharedSecret;
        this.endpoints = builder.endpoints;
    }

    public final String nodeID() {
        return this.nodeID;
    }

    public final String sharedSecret() {
        return this.sharedSecret;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public final List<Endpoint> endpoints() {
        return this.endpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeID());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterComputeNodeGroupInstanceResponse)) {
            return false;
        }
        RegisterComputeNodeGroupInstanceResponse other = (RegisterComputeNodeGroupInstanceResponse)((Object)obj);
        return Objects.equals(this.nodeID(), other.nodeID()) && Objects.equals(this.sharedSecret(), other.sharedSecret()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterComputeNodeGroupInstanceResponse").add("NodeID", (Object)this.nodeID()).add("SharedSecret", (Object)(this.sharedSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nodeID": {
                return Optional.ofNullable(clazz.cast(this.nodeID()));
            }
            case "sharedSecret": {
                return Optional.ofNullable(clazz.cast(this.sharedSecret()));
            }
            case "endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterComputeNodeGroupInstanceResponse, T> g) {
        return obj -> g.apply((RegisterComputeNodeGroupInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcsResponse.BuilderImpl
    implements Builder {
        private String nodeID;
        private String sharedSecret;
        private List<Endpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterComputeNodeGroupInstanceResponse model) {
            super(model);
            this.nodeID(model.nodeID);
            this.sharedSecret(model.sharedSecret);
            this.endpoints(model.endpoints);
        }

        public final String getNodeID() {
            return this.nodeID;
        }

        public final void setNodeID(String nodeID) {
            this.nodeID = nodeID;
        }

        @Override
        public final Builder nodeID(String nodeID) {
            this.nodeID = nodeID;
            return this;
        }

        public final String getSharedSecret() {
            return this.sharedSecret;
        }

        public final void setSharedSecret(String sharedSecret) {
            this.sharedSecret = sharedSecret;
        }

        @Override
        public final Builder sharedSecret(String sharedSecret) {
            this.sharedSecret = sharedSecret;
            return this;
        }

        public final List<Endpoint.Builder> getEndpoints() {
            List<Endpoint.Builder> result = EndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<Endpoint.BuilderImpl> endpoints) {
            this.endpoints = EndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<Endpoint> endpoints) {
            this.endpoints = EndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Endpoint ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<Endpoint.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RegisterComputeNodeGroupInstanceResponse build() {
            return new RegisterComputeNodeGroupInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterComputeNodeGroupInstanceResponse> {
        public Builder nodeID(String var1);

        public Builder sharedSecret(String var1);

        public Builder endpoints(Collection<Endpoint> var1);

        public Builder endpoints(Endpoint ... var1);

        public Builder endpoints(Consumer<Endpoint.Builder> ... var1);
    }
}

