/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChallengeResponse extends PcaConnectorScepResponse implements
        ToCopyableBuilder<CreateChallengeResponse.Builder, CreateChallengeResponse> {
    private static final SdkField<Challenge> CHALLENGE_FIELD = SdkField.<Challenge> builder(MarshallingType.SDK_POJO)
            .memberName("Challenge").getter(getter(CreateChallengeResponse::challenge)).setter(setter(Builder::challenge))
            .constructor(Challenge::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Challenge").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Challenge challenge;

    private CreateChallengeResponse(BuilderImpl builder) {
        super(builder);
        this.challenge = builder.challenge;
    }

    /**
     * <p>
     * Returns the challenge details for the specified connector.
     * </p>
     * 
     * @return Returns the challenge details for the specified connector.
     */
    public final Challenge challenge() {
        return challenge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(challenge());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChallengeResponse)) {
            return false;
        }
        CreateChallengeResponse other = (CreateChallengeResponse) obj;
        return Objects.equals(challenge(), other.challenge());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChallengeResponse").add("Challenge", challenge()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Challenge":
            return Optional.ofNullable(clazz.cast(challenge()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Challenge", CHALLENGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChallengeResponse, T> g) {
        return obj -> g.apply((CreateChallengeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PcaConnectorScepResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateChallengeResponse> {
        /**
         * <p>
         * Returns the challenge details for the specified connector.
         * </p>
         * 
         * @param challenge
         *        Returns the challenge details for the specified connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challenge(Challenge challenge);

        /**
         * <p>
         * Returns the challenge details for the specified connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link Challenge.Builder} avoiding the need to
         * create one manually via {@link Challenge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Challenge.Builder#build()} is called immediately and its result
         * is passed to {@link #challenge(Challenge)}.
         * 
         * @param challenge
         *        a consumer that will call methods on {@link Challenge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #challenge(Challenge)
         */
        default Builder challenge(Consumer<Challenge.Builder> challenge) {
            return challenge(Challenge.builder().applyMutation(challenge).build());
        }
    }

    static final class BuilderImpl extends PcaConnectorScepResponse.BuilderImpl implements Builder {
        private Challenge challenge;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChallengeResponse model) {
            super(model);
            challenge(model.challenge);
        }

        public final Challenge.Builder getChallenge() {
            return challenge != null ? challenge.toBuilder() : null;
        }

        public final void setChallenge(Challenge.BuilderImpl challenge) {
            this.challenge = challenge != null ? challenge.build() : null;
        }

        @Override
        public final Builder challenge(Challenge challenge) {
            this.challenge = challenge;
            return this;
        }

        @Override
        public CreateChallengeResponse build() {
            return new CreateChallengeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
