/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorscep.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntuneConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntuneConfiguration> {
    private static final SdkField<String> AZURE_APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AzureApplicationId").getter(IntuneConfiguration.getter(IntuneConfiguration::azureApplicationId)).setter(IntuneConfiguration.setter(Builder::azureApplicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AzureApplicationId").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(IntuneConfiguration.getter(IntuneConfiguration::domain)).setter(IntuneConfiguration.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AZURE_APPLICATION_ID_FIELD, DOMAIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IntuneConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String azureApplicationId;
    private final String domain;

    private IntuneConfiguration(BuilderImpl builder) {
        this.azureApplicationId = builder.azureApplicationId;
        this.domain = builder.domain;
    }

    public final String azureApplicationId() {
        return this.azureApplicationId;
    }

    public final String domain() {
        return this.domain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.azureApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntuneConfiguration)) {
            return false;
        }
        IntuneConfiguration other = (IntuneConfiguration)obj;
        return Objects.equals(this.azureApplicationId(), other.azureApplicationId()) && Objects.equals(this.domain(), other.domain());
    }

    public final String toString() {
        return ToString.builder((String)"IntuneConfiguration").add("AzureApplicationId", (Object)this.azureApplicationId()).add("Domain", (Object)this.domain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AzureApplicationId": {
                return Optional.ofNullable(clazz.cast(this.azureApplicationId()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AzureApplicationId", AZURE_APPLICATION_ID_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntuneConfiguration, T> g) {
        return obj -> g.apply((IntuneConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String azureApplicationId;
        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(IntuneConfiguration model) {
            this.azureApplicationId(model.azureApplicationId);
            this.domain(model.domain);
        }

        public final String getAzureApplicationId() {
            return this.azureApplicationId;
        }

        public final void setAzureApplicationId(String azureApplicationId) {
            this.azureApplicationId = azureApplicationId;
        }

        @Override
        public final Builder azureApplicationId(String azureApplicationId) {
            this.azureApplicationId = azureApplicationId;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public IntuneConfiguration build() {
            return new IntuneConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntuneConfiguration> {
        public Builder azureApplicationId(String var1);

        public Builder domain(String var1);
    }
}

