/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Application policies describe what the certificate can be used for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationPolicy.Builder, ApplicationPolicy> {
    private static final SdkField<String> POLICY_OBJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyObjectIdentifier").getter(getter(ApplicationPolicy::policyObjectIdentifier))
            .setter(setter(Builder::policyObjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyObjectIdentifier").build())
            .build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyType").getter(getter(ApplicationPolicy::policyTypeAsString)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            POLICY_OBJECT_IDENTIFIER_FIELD, POLICY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyObjectIdentifier;

    private final String policyType;

    private final Type type;

    private ApplicationPolicy(BuilderImpl builder) {
        this.policyObjectIdentifier = builder.policyObjectIdentifier;
        this.policyType = builder.policyType;
        this.type = builder.type;
    }

    /**
     * <p>
     * The object identifier (OID) of an application policy.
     * </p>
     * 
     * @return The object identifier (OID) of an application policy.
     */
    public final String policyObjectIdentifier() {
        return policyObjectIdentifier;
    }

    /**
     * <p>
     * The type of application policy
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link ApplicationPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of application policy
     * @see ApplicationPolicyType
     */
    public final ApplicationPolicyType policyType() {
        return ApplicationPolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of application policy
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link ApplicationPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of application policy
     * @see ApplicationPolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyObjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationPolicy)) {
            return false;
        }
        ApplicationPolicy other = (ApplicationPolicy) obj;
        return Objects.equals(policyObjectIdentifier(), other.policyObjectIdentifier())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationPolicy").add("PolicyObjectIdentifier", policyObjectIdentifier())
                .add("PolicyType", policyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyObjectIdentifier":
            return Optional.ofNullable(clazz.cast(policyObjectIdentifier()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #policyObjectIdentifier()} initialized to the given value.
     *
     * <p>
     * The object identifier (OID) of an application policy.
     * </p>
     * 
     * @param policyObjectIdentifier
     *        The object identifier (OID) of an application policy.
     */
    public static ApplicationPolicy fromPolicyObjectIdentifier(String policyObjectIdentifier) {
        return builder().policyObjectIdentifier(policyObjectIdentifier).build();
    }

    /**
     * Create an instance of this class with {@link #policyTypeAsString()} initialized to the given value.
     *
     * <p>
     * The type of application policy
     * </p>
     * 
     * @param policyType
     *        The type of application policy
     * @see ApplicationPolicyType
     */
    public static ApplicationPolicy fromPolicyType(String policyType) {
        return builder().policyType(policyType).build();
    }

    /**
     * Create an instance of this class with {@link #policyTypeAsString()} initialized to the given value.
     *
     * <p>
     * The type of application policy
     * </p>
     * 
     * @param policyType
     *        The type of application policy
     * @see ApplicationPolicyType
     */
    public static ApplicationPolicy fromPolicyType(ApplicationPolicyType policyType) {
        return builder().policyType(policyType).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyObjectIdentifier", POLICY_OBJECT_IDENTIFIER_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationPolicy, T> g) {
        return obj -> g.apply((ApplicationPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationPolicy> {
        /**
         * <p>
         * The object identifier (OID) of an application policy.
         * </p>
         * 
         * @param policyObjectIdentifier
         *        The object identifier (OID) of an application policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyObjectIdentifier(String policyObjectIdentifier);

        /**
         * <p>
         * The type of application policy
         * </p>
         * 
         * @param policyType
         *        The type of application policy
         * @see ApplicationPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationPolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of application policy
         * </p>
         * 
         * @param policyType
         *        The type of application policy
         * @see ApplicationPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationPolicyType
         */
        Builder policyType(ApplicationPolicyType policyType);
    }

    static final class BuilderImpl implements Builder {
        private String policyObjectIdentifier;

        private String policyType;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationPolicy model) {
            policyObjectIdentifier(model.policyObjectIdentifier);
            policyType(model.policyType);
        }

        public final String getPolicyObjectIdentifier() {
            return policyObjectIdentifier;
        }

        public final void setPolicyObjectIdentifier(String policyObjectIdentifier) {
            Object oldValue = this.policyObjectIdentifier;
            this.policyObjectIdentifier = policyObjectIdentifier;
            handleUnionValueChange(Type.POLICY_OBJECT_IDENTIFIER, oldValue, this.policyObjectIdentifier);
        }

        @Override
        public final Builder policyObjectIdentifier(String policyObjectIdentifier) {
            Object oldValue = this.policyObjectIdentifier;
            this.policyObjectIdentifier = policyObjectIdentifier;
            handleUnionValueChange(Type.POLICY_OBJECT_IDENTIFIER, oldValue, this.policyObjectIdentifier);
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            Object oldValue = this.policyType;
            this.policyType = policyType;
            handleUnionValueChange(Type.POLICY_TYPE, oldValue, this.policyType);
        }

        @Override
        public final Builder policyType(String policyType) {
            Object oldValue = this.policyType;
            this.policyType = policyType;
            handleUnionValueChange(Type.POLICY_TYPE, oldValue, this.policyType);
            return this;
        }

        @Override
        public final Builder policyType(ApplicationPolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        @Override
        public ApplicationPolicy build() {
            return new ApplicationPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ApplicationPolicy#type()
     */
    public enum Type {
        POLICY_OBJECT_IDENTIFIER,

        POLICY_TYPE,

        UNKNOWN_TO_SDK_VERSION
    }
}
