/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pcaconnectorad.model.TemplateV2;
import software.amazon.awssdk.services.pcaconnectorad.model.TemplateV3;
import software.amazon.awssdk.services.pcaconnectorad.model.TemplateV4;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateDefinition> {
    private static final SdkField<TemplateV2> TEMPLATE_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateV2").getter(TemplateDefinition.getter(TemplateDefinition::templateV2)).setter(TemplateDefinition.setter(Builder::templateV2)).constructor(TemplateV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateV2").build()}).build();
    private static final SdkField<TemplateV3> TEMPLATE_V3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateV3").getter(TemplateDefinition.getter(TemplateDefinition::templateV3)).setter(TemplateDefinition.setter(Builder::templateV3)).constructor(TemplateV3::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateV3").build()}).build();
    private static final SdkField<TemplateV4> TEMPLATE_V4_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateV4").getter(TemplateDefinition.getter(TemplateDefinition::templateV4)).setter(TemplateDefinition.setter(Builder::templateV4)).constructor(TemplateV4::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateV4").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_V2_FIELD, TEMPLATE_V3_FIELD, TEMPLATE_V4_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TemplateDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TemplateV2 templateV2;
    private final TemplateV3 templateV3;
    private final TemplateV4 templateV4;
    private final Type type;

    private TemplateDefinition(BuilderImpl builder) {
        this.templateV2 = builder.templateV2;
        this.templateV3 = builder.templateV3;
        this.templateV4 = builder.templateV4;
        this.type = builder.type;
    }

    public final TemplateV2 templateV2() {
        return this.templateV2;
    }

    public final TemplateV3 templateV3() {
        return this.templateV3;
    }

    public final TemplateV4 templateV4() {
        return this.templateV4;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateV2());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateV3());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateV4());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateDefinition)) {
            return false;
        }
        TemplateDefinition other = (TemplateDefinition)obj;
        return Objects.equals(this.templateV2(), other.templateV2()) && Objects.equals(this.templateV3(), other.templateV3()) && Objects.equals(this.templateV4(), other.templateV4());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateDefinition").add("TemplateV2", (Object)this.templateV2()).add("TemplateV3", (Object)this.templateV3()).add("TemplateV4", (Object)this.templateV4()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateV2": {
                return Optional.ofNullable(clazz.cast(this.templateV2()));
            }
            case "TemplateV3": {
                return Optional.ofNullable(clazz.cast(this.templateV3()));
            }
            case "TemplateV4": {
                return Optional.ofNullable(clazz.cast(this.templateV4()));
            }
        }
        return Optional.empty();
    }

    public static TemplateDefinition fromTemplateV2(TemplateV2 templateV2) {
        return (TemplateDefinition)TemplateDefinition.builder().templateV2(templateV2).build();
    }

    public static TemplateDefinition fromTemplateV2(Consumer<TemplateV2.Builder> templateV2) {
        TemplateV2.Builder builder = TemplateV2.builder();
        templateV2.accept(builder);
        return TemplateDefinition.fromTemplateV2((TemplateV2)builder.build());
    }

    public static TemplateDefinition fromTemplateV3(TemplateV3 templateV3) {
        return (TemplateDefinition)TemplateDefinition.builder().templateV3(templateV3).build();
    }

    public static TemplateDefinition fromTemplateV3(Consumer<TemplateV3.Builder> templateV3) {
        TemplateV3.Builder builder = TemplateV3.builder();
        templateV3.accept(builder);
        return TemplateDefinition.fromTemplateV3((TemplateV3)builder.build());
    }

    public static TemplateDefinition fromTemplateV4(TemplateV4 templateV4) {
        return (TemplateDefinition)TemplateDefinition.builder().templateV4(templateV4).build();
    }

    public static TemplateDefinition fromTemplateV4(Consumer<TemplateV4.Builder> templateV4) {
        TemplateV4.Builder builder = TemplateV4.builder();
        templateV4.accept(builder);
        return TemplateDefinition.fromTemplateV4((TemplateV4)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TemplateV2", TEMPLATE_V2_FIELD);
        map.put("TemplateV3", TEMPLATE_V3_FIELD);
        map.put("TemplateV4", TEMPLATE_V4_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateDefinition, T> g) {
        return obj -> g.apply((TemplateDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEMPLATE_V2,
        TEMPLATE_V3,
        TEMPLATE_V4,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private TemplateV2 templateV2;
        private TemplateV3 templateV3;
        private TemplateV4 templateV4;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateDefinition model) {
            this.templateV2(model.templateV2);
            this.templateV3(model.templateV3);
            this.templateV4(model.templateV4);
        }

        public final TemplateV2.Builder getTemplateV2() {
            return this.templateV2 != null ? this.templateV2.toBuilder() : null;
        }

        public final void setTemplateV2(TemplateV2.BuilderImpl templateV2) {
            TemplateV2 oldValue = this.templateV2;
            this.templateV2 = templateV2 != null ? templateV2.build() : null;
            this.handleUnionValueChange(Type.TEMPLATE_V2, oldValue, this.templateV2);
        }

        @Override
        public final Builder templateV2(TemplateV2 templateV2) {
            TemplateV2 oldValue = this.templateV2;
            this.templateV2 = templateV2;
            this.handleUnionValueChange(Type.TEMPLATE_V2, oldValue, this.templateV2);
            return this;
        }

        public final TemplateV3.Builder getTemplateV3() {
            return this.templateV3 != null ? this.templateV3.toBuilder() : null;
        }

        public final void setTemplateV3(TemplateV3.BuilderImpl templateV3) {
            TemplateV3 oldValue = this.templateV3;
            this.templateV3 = templateV3 != null ? templateV3.build() : null;
            this.handleUnionValueChange(Type.TEMPLATE_V3, oldValue, this.templateV3);
        }

        @Override
        public final Builder templateV3(TemplateV3 templateV3) {
            TemplateV3 oldValue = this.templateV3;
            this.templateV3 = templateV3;
            this.handleUnionValueChange(Type.TEMPLATE_V3, oldValue, this.templateV3);
            return this;
        }

        public final TemplateV4.Builder getTemplateV4() {
            return this.templateV4 != null ? this.templateV4.toBuilder() : null;
        }

        public final void setTemplateV4(TemplateV4.BuilderImpl templateV4) {
            TemplateV4 oldValue = this.templateV4;
            this.templateV4 = templateV4 != null ? templateV4.build() : null;
            this.handleUnionValueChange(Type.TEMPLATE_V4, oldValue, this.templateV4);
        }

        @Override
        public final Builder templateV4(TemplateV4 templateV4) {
            TemplateV4 oldValue = this.templateV4;
            this.templateV4 = templateV4;
            this.handleUnionValueChange(Type.TEMPLATE_V4, oldValue, this.templateV4);
            return this;
        }

        public TemplateDefinition build() {
            return new TemplateDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateDefinition> {
        public Builder templateV2(TemplateV2 var1);

        default public Builder templateV2(Consumer<TemplateV2.Builder> templateV2) {
            return this.templateV2((TemplateV2)((TemplateV2.Builder)TemplateV2.builder().applyMutation(templateV2)).build());
        }

        public Builder templateV3(TemplateV3 var1);

        default public Builder templateV3(Consumer<TemplateV3.Builder> templateV3) {
            return this.templateV3((TemplateV3)((TemplateV3.Builder)TemplateV3.builder().applyMutation(templateV3)).build());
        }

        public Builder templateV4(TemplateV4 var1);

        default public Builder templateV4(Consumer<TemplateV4.Builder> templateV4) {
            return this.templateV4((TemplateV4)((TemplateV4.Builder)TemplateV4.builder().applyMutation(templateV4)).build());
        }
    }
}

