/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServicePrincipalNameStatusReason {
    DIRECTORY_ACCESS_DENIED("DIRECTORY_ACCESS_DENIED"),
    DIRECTORY_NOT_REACHABLE("DIRECTORY_NOT_REACHABLE"),
    DIRECTORY_RESOURCE_NOT_FOUND("DIRECTORY_RESOURCE_NOT_FOUND"),
    SPN_EXISTS_ON_DIFFERENT_AD_OBJECT("SPN_EXISTS_ON_DIFFERENT_AD_OBJECT"),
    SPN_LIMIT_EXCEEDED("SPN_LIMIT_EXCEEDED"),
    INTERNAL_FAILURE("INTERNAL_FAILURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServicePrincipalNameStatusReason> VALUE_MAP;
    private final String value;

    private ServicePrincipalNameStatusReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServicePrincipalNameStatusReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServicePrincipalNameStatusReason> knownValues() {
        EnumSet<ServicePrincipalNameStatusReason> knownValues = EnumSet.allOf(ServicePrincipalNameStatusReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServicePrincipalNameStatusReason.class, ServicePrincipalNameStatusReason::toString);
    }
}

