/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyUsagePropertyFlags
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyUsagePropertyFlags> {
    private static final SdkField<Boolean> DECRYPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Decrypt").getter(KeyUsagePropertyFlags.getter(KeyUsagePropertyFlags::decrypt)).setter(KeyUsagePropertyFlags.setter(Builder::decrypt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Decrypt").build()}).build();
    private static final SdkField<Boolean> KEY_AGREEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KeyAgreement").getter(KeyUsagePropertyFlags.getter(KeyUsagePropertyFlags::keyAgreement)).setter(KeyUsagePropertyFlags.setter(Builder::keyAgreement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAgreement").build()}).build();
    private static final SdkField<Boolean> SIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Sign").getter(KeyUsagePropertyFlags.getter(KeyUsagePropertyFlags::sign)).setter(KeyUsagePropertyFlags.setter(Builder::sign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sign").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPT_FIELD, KEY_AGREEMENT_FIELD, SIGN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KeyUsagePropertyFlags.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean decrypt;
    private final Boolean keyAgreement;
    private final Boolean sign;

    private KeyUsagePropertyFlags(BuilderImpl builder) {
        this.decrypt = builder.decrypt;
        this.keyAgreement = builder.keyAgreement;
        this.sign = builder.sign;
    }

    public final Boolean decrypt() {
        return this.decrypt;
    }

    public final Boolean keyAgreement() {
        return this.keyAgreement;
    }

    public final Boolean sign() {
        return this.sign;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.decrypt());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAgreement());
        hashCode = 31 * hashCode + Objects.hashCode(this.sign());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyUsagePropertyFlags)) {
            return false;
        }
        KeyUsagePropertyFlags other = (KeyUsagePropertyFlags)obj;
        return Objects.equals(this.decrypt(), other.decrypt()) && Objects.equals(this.keyAgreement(), other.keyAgreement()) && Objects.equals(this.sign(), other.sign());
    }

    public final String toString() {
        return ToString.builder((String)"KeyUsagePropertyFlags").add("Decrypt", (Object)this.decrypt()).add("KeyAgreement", (Object)this.keyAgreement()).add("Sign", (Object)this.sign()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Decrypt": {
                return Optional.ofNullable(clazz.cast(this.decrypt()));
            }
            case "KeyAgreement": {
                return Optional.ofNullable(clazz.cast(this.keyAgreement()));
            }
            case "Sign": {
                return Optional.ofNullable(clazz.cast(this.sign()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Boolean>> map = new HashMap<String, SdkField<Boolean>>();
        map.put("Decrypt", DECRYPT_FIELD);
        map.put("KeyAgreement", KEY_AGREEMENT_FIELD);
        map.put("Sign", SIGN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyUsagePropertyFlags, T> g) {
        return obj -> g.apply((KeyUsagePropertyFlags)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean decrypt;
        private Boolean keyAgreement;
        private Boolean sign;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyUsagePropertyFlags model) {
            this.decrypt(model.decrypt);
            this.keyAgreement(model.keyAgreement);
            this.sign(model.sign);
        }

        public final Boolean getDecrypt() {
            return this.decrypt;
        }

        public final void setDecrypt(Boolean decrypt) {
            this.decrypt = decrypt;
        }

        @Override
        public final Builder decrypt(Boolean decrypt) {
            this.decrypt = decrypt;
            return this;
        }

        public final Boolean getKeyAgreement() {
            return this.keyAgreement;
        }

        public final void setKeyAgreement(Boolean keyAgreement) {
            this.keyAgreement = keyAgreement;
        }

        @Override
        public final Builder keyAgreement(Boolean keyAgreement) {
            this.keyAgreement = keyAgreement;
            return this;
        }

        public final Boolean getSign() {
            return this.sign;
        }

        public final void setSign(Boolean sign) {
            this.sign = sign;
        }

        @Override
        public final Builder sign(Boolean sign) {
            this.sign = sign;
            return this;
        }

        public KeyUsagePropertyFlags build() {
            return new KeyUsagePropertyFlags(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyUsagePropertyFlags> {
        public Builder decrypt(Boolean var1);

        public Builder keyAgreement(Boolean var1);

        public Builder sign(Boolean var1);
    }
}

